/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.soulbind;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.ITintModifier;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoulbindProperty
extends Property
implements ITintModifier {
    static ResourceKey<DamageType> SOUL_DAMAGE_KEY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"soul_escaped"));

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (!user.level().isClientSide() && user.getRandom().nextFloat() < 0.001f && InfusedPropertiesHelper.hasInfusedProperty(stack, this.asHolder())) {
            Vec3 lookVec = user.getLookAngle().scale(0.5);
            ((ServerLevel)user.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL, user.position().x + lookVec.x, user.getEyeY() + lookVec.y, user.position().z + lookVec.z, 1, 0.0, 0.05, 0.0, 0.05);
            user.playSound((SoundEvent)SoundEvents.SOUL_ESCAPE.value(), 1.0f, 1.0f);
            InfusedPropertiesHelper.removeProperty(stack, this.asHolder());
            if (user.getRandom().nextFloat() < 0.2f && user instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)user;
                living.hurt(new DamageSource((Holder)user.damageSources().damageTypes.getHolderOrThrow(SOUL_DAMAGE_KEY)), 3.0f);
            }
        }
    }

    @Override
    public int getTint(ItemStack stack, int tintIndex, int originalTint, int currentTint) {
        float partialSecond = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        return FastColor.ARGB32.lerp((float)(Mth.sin((float)((float)Math.PI * 2 * (partialSecond / 2.0f))) * 0.5f + 0.5f), (int)currentTint, (int)FastColor.ARGB32.color((int)FastColor.ARGB32.alpha((int)currentTint), (int)12910079));
    }

    @Override
    public int getColor(ItemStack stack) {
        float partialSecond = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        return FastColor.ARGB32.lerp((float)(Mth.sin((float)((float)Math.PI * 2 * (partialSecond / 2.0f))) * 0.5f + 0.5f), (int)2804175, (int)12910079);
    }
}

