/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.soulbind;

import java.util.Optional;
import java.util.UUID;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.properties.special.AuxiliaryProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ClientUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class VengefulProperty
extends Property
implements IDataHolder<Optional<UUID>> {
    @Override
    public void modifyAttackDamage(Entity user, ItemStack weapon, LivingDamageEvent.Pre event) {
        Optional revengeTarget = (Optional)this.getData(weapon);
        if (revengeTarget.isPresent() && event.getEntity().getUUID().equals(revengeTarget.get())) {
            event.setNewDamage(event.getNewDamage() * 1.85f);
            if (user.level().isClientSide) {
                ClientUtil.createTrackedParticles((Entity)event.getEntity(), (ParticleOptions)ParticleTypes.ENCHANTED_HIT);
            }
        } else {
            event.setNewDamage(event.getNewDamage() * 0.65f);
        }
    }

    @Override
    public void onDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, DamageSource damageSource) {
        Optional revengeTarget;
        Entity source = damageSource.getEntity();
        if (slot == EquipmentSlot.MAINHAND && source != null && ((revengeTarget = (Optional)this.getData(weapon)).isEmpty() || !((UUID)revengeTarget.get()).equals(source.getUUID()))) {
            this.setData(weapon, Optional.of(source.getUUID()));
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 7542554;
    }

    @Override
    public Optional<UUID> readData(CompoundTag tag) {
        return tag.hasUUID("revenge_target") ? Optional.of(tag.getUUID("revenge_target")) : Optional.empty();
    }

    @Override
    public CompoundTag writeData(final Optional<UUID> data) {
        return new CompoundTag(this){
            {
                data.ifPresent(uuid -> this.putUUID("revenge_target", (UUID)uuid));
            }
        };
    }

    @Override
    public Optional<UUID> getDefaultData() {
        return Optional.empty();
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AuxiliaryProperty.triggerAuxiliaryEffects(player, (propertyHolder, stack) -> {
                if (propertyHolder.equals(AlchemancyProperties.VENGEFUL)) {
                    ((Property)propertyHolder.value()).modifyDamageReceived((LivingEntity)player, (ItemStack)stack, EquipmentSlot.MAINHAND, event);
                }
            });
        }
    }
}

