/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;

public class AirWalkingProperty
extends Property
implements IDataHolder<Double> {
    public static final DustParticleOptions PARTICLES = new DustParticleOptions(Vec3.fromRGB24((int)4718526).toVector3f(), 1.5f);

    @Override
    public void onStackedOverMe(ItemStack carriedItem, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.HOLLOW) && !((ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(stack)).isEmpty() || !carriedItem.isEmpty()) {
            return;
        }
        this.removeData(stack);
    }

    @Override
    public void onItemPickedUp(Player player, ItemStack stack, ItemEntity itemEntity) {
        this.removeData(stack);
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (inventorySlot != 36) {
            this.removeData(stack);
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.FEET && slot != EquipmentSlot.BODY) {
            this.removeData(stack);
            return;
        }
        if (user.isShiftKeyDown()) {
            return;
        }
        if (this.getData(stack) == null || user.onGround()) {
            this.setData(stack, Double.valueOf(user.getY() + user.getDeltaMovement().y));
        } else if (this.getData(stack) != null) {
            double y = (Double)this.getData(stack);
            Vec3 vec = user.getDeltaMovement();
            if (user.getY() + vec.y <= y) {
                if (user.getY() < y) {
                    y = user.getY();
                    this.setData(stack, Double.valueOf(y));
                }
                if (!user.onGround()) {
                    CommonHooks.onLivingFall((LivingEntity)user, (float)user.fallDistance, (float)0.0f);
                }
                user.resetFallDistance();
                user.setOnGround(user.getY() <= y);
                user.setDeltaMovement(new Vec3(vec.x, Math.min(Math.max(y - user.getY(), vec.y), 1.0), vec.z));
                AirWalkingProperty.playParticles((Entity)user, y, stack, 5);
            }
        }
    }

    public static void playParticles(Entity user, double y, ItemStack stack, int amount) {
        Level level = user.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(SparklingProperty.getParticles(stack).orElse((ParticleOptions)PARTICLES), user.getX(), y, user.getZ(), amount, (double)(user.getBbWidth() * 0.5f), 0.0, (double)(user.getBbWidth() * 0.5f), 0.0);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 4718526;
    }

    @Override
    public Double readData(CompoundTag tag) {
        return tag.getDouble("target_y");
    }

    @Override
    public CompoundTag writeData(final Double data) {
        return new CompoundTag(this){
            {
                if (data != null) {
                    this.putDouble("target_y", data);
                }
            }
        };
    }

    @Override
    public Double getDefaultData() {
        return null;
    }
}

