/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.item.components.PropertyModifierComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber
public class AuxiliaryProperty
extends Property {
    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (user instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)user;
            AuxiliaryProperty.triggerAuxiliaryEffects(stack, (Holder<Property> propertyHolder) -> ((Property)propertyHolder.value()).onEquippedTick(living, EquipmentSlot.MAINHAND, stack));
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 13297377;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Entity entity;
        if (event.getSource().is(AlchemancyTags.DamageTypes.TRIGGERS_ON_HIT_EFFECTS) && (entity = event.getSource().getDirectEntity()) instanceof Player) {
            Player user = (Player)entity;
            AuxiliaryProperty.triggerAuxiliaryEffects(user, (Holder<Property> holder, ItemStack stack) -> ((Property)holder.value()).modifyAttackDamage((Entity)user, (ItemStack)stack, event));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onIncomingDamage(LivingIncomingDamageEvent event) {
        Entity entity;
        if (event.getSource().is(AlchemancyTags.DamageTypes.TRIGGERS_ON_HIT_EFFECTS) && (entity = event.getSource().getDirectEntity()) instanceof Player) {
            Player user = (Player)entity;
            AuxiliaryProperty.triggerAuxiliaryEffects(user, (Holder<Property> propertyHolder, ItemStack stack) -> ((Property)propertyHolder.value()).onIncomingAttack((Entity)user, (ItemStack)stack, event.getEntity(), event));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onLivingDeath(LivingDeathEvent event) {
        Player user;
        LivingEntity livingEntity;
        if (event.getSource().is(AlchemancyTags.DamageTypes.TRIGGERS_ON_HIT_EFFECTS) && (livingEntity = event.getSource().getDirectEntity()) instanceof Player) {
            user = (Player)livingEntity;
            AuxiliaryProperty.triggerAuxiliaryEffects(user, (Holder<Property> propertyHolder, ItemStack stack) -> ((Property)propertyHolder.value()).onKill(event.getEntity(), (LivingEntity)user, (ItemStack)stack, event));
        }
        if ((livingEntity = event.getEntity()) instanceof Player) {
            user = (Player)livingEntity;
            AuxiliaryProperty.triggerAuxiliaryEffects(user, (Holder<Property> propertyHolder, ItemStack stack) -> ((Property)propertyHolder.value()).onUserDeath((LivingEntity)user, (ItemStack)stack, EquipmentSlot.MAINHAND, event));
        }
    }

    @SubscribeEvent
    private static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AuxiliaryProperty.triggerAuxiliaryEffects(player, (Holder<Property> propertyHolder, ItemStack stack) -> ((Property)propertyHolder.value()).onMobEffectAdded((ItemStack)stack, EquipmentSlot.MAINHAND, (LivingEntity)player, event));
        }
    }

    @SubscribeEvent
    private static void onEffectApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AuxiliaryProperty.triggerAuxiliaryEffects(player, (Holder<Property> propertyHolder, ItemStack stack) -> ((Property)propertyHolder.value()).isMobEffectApplicable((ItemStack)stack, EquipmentSlot.MAINHAND, (LivingEntity)player, event));
        }
    }

    public static void triggerAuxiliaryEffects(ItemStack stack, Consumer<Holder<Property>> consumer) {
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.AUXILIARY)) {
            if (PropertyModifierComponent.getOrElse(stack, AlchemancyProperties.AUXILIARY, AlchemancyProperties.Modifiers.IGNORE_INFUSED, false).booleanValue()) {
                InfusedPropertiesHelper.forEachInnateProperty(stack, consumer);
            } else {
                InfusedPropertiesHelper.forEachProperty(stack, consumer);
            }
        }
    }

    public static void triggerAuxiliaryEffects(Player user, BiConsumer<Holder<Property>, ItemStack> consumer) {
        Inventory inventory = user.getInventory();
        for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
            ItemStack stack = inventory.getItem(slot);
            AuxiliaryProperty.triggerAuxiliaryEffects(stack, (Holder<Property> propertyHolder) -> consumer.accept((Holder<Property>)propertyHolder, stack));
        }
    }

    @Override
    public boolean hasJournalEntry() {
        return false;
    }
}

