/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.Arrays;
import net.cibernet.alchemancy.network.S2CEntitySyncTintColorPayload;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.TintedProperty;
import net.cibernet.alchemancy.registries.AlchemancyDataAttachments;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class ChromatizeProperty
extends Property {
    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            ChromatizeProperty.setLivingColor(living, (Integer[])((TintedProperty)AlchemancyProperties.TINTED.get()).getData(stack));
        }
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        EntityHitResult entityHit;
        Entity entity;
        if (rayTraceResult instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)rayTraceResult).getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ChromatizeProperty.setLivingColor(living, (Integer[])((TintedProperty)AlchemancyProperties.TINTED.get()).getData(stack));
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return ((TintedProperty)AlchemancyProperties.TINTED.get()).getColor(stack);
    }

    @SubscribeEvent
    private static void onLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new S2CEntitySyncTintColorPayload((Entity)event.getEntity()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    private static void onUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().is(Tags.Items.DRINKS_MILK)) {
            ChromatizeProperty.setLivingColor(event.getEntity(), -1);
        }
    }

    @SubscribeEvent
    private static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)player;
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new S2CEntitySyncTintColorPayload((Entity)target), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void setLivingColor(LivingEntity target, Integer ... color) {
        target.setData(AlchemancyDataAttachments.ENTITY_TINT.get(), Arrays.stream(color).toList());
        if (!target.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)new S2CEntitySyncTintColorPayload((Entity)target), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

