/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import net.cibernet.alchemancy.client.particle.options.SparkParticleOptions;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyParticles;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DashingProperty
extends Property
implements IDataHolder<Tuple<Boolean, Integer>> {
    private final int maxDashes;
    private final int[] colors;
    private final float dashStrength;
    public static final ParticleOptions CRYSTAL_PARTICLES = new SparkParticleOptions((ParticleType<SparkParticleOptions>)((ParticleType)AlchemancyParticles.CLOUD_SMOKE.get()), Vec3.fromRGB24((int)14186495).toVector3f(), 2.0f, false);
    public static final ParticleOptions CLOUD_PARTICLES = new SparkParticleOptions((ParticleType<SparkParticleOptions>)((ParticleType)AlchemancyParticles.CLOUD_SMOKE.get()), Vec3.fromRGB24((int)5551359).toVector3f(), 2.0f, false);
    private static final Tuple<Boolean, Integer> DEFAULT = new Tuple((Object)false, (Object)0);

    public DashingProperty(float dashStrength, int ... colors) {
        this.maxDashes = colors.length - 1;
        this.colors = colors;
        this.dashStrength = dashStrength;
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        super.onEquippedTick(user, slot, stack);
        if (user.isSprinting() && !this.getSprinting(stack)) {
            if (slot.isArmor() || !InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.INTERACTABLE)) {
                this.dash(user, stack, slot);
            }
        } else if (user.onGround()) {
            this.setDashCount(stack, 0);
        }
        this.setSprinting(stack, user.isSprinting());
        if (((Tuple)this.getData(stack)).equals(this.getDefaultData())) {
            this.removeData(stack);
        }
    }

    private void setDashCount(ItemStack stack, int count) {
        this.setData(stack, new Tuple((Object)((Boolean)((Tuple)this.getData(stack)).getA()), (Object)count));
    }

    private int getDashCount(ItemStack stack) {
        return (Integer)((Tuple)this.getData(stack)).getB();
    }

    private void setSprinting(ItemStack stack, boolean sprinting) {
        this.setData(stack, new Tuple((Object)sprinting, (Object)((Integer)((Tuple)this.getData(stack)).getB())));
    }

    private boolean getSprinting(ItemStack stack) {
        return (Boolean)((Tuple)this.getData(stack)).getA();
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        if (source == null) {
            return;
        }
        if (source instanceof LivingEntity) {
            LivingEntity user = (LivingEntity)source;
            this.dash(user, stack, EquipmentSlot.MAINHAND);
        }
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (!(isCurrentItem || inventorySlot >= 36 && inventorySlot <= 40 || InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.AUXILIARY))) {
            this.removeData(stack);
        }
    }

    public void dash(LivingEntity user, ItemStack stack, EquipmentSlot slot) {
        int dashes = this.getDashCount(stack);
        float dashStrength = this.dashStrength * user.getSpeed() * 5.0f;
        if (dashes >= this.maxDashes + (user.level().isClientSide() ? 1 : 0)) {
            return;
        }
        user.setDeltaMovement(user.getLookAngle().normalize().scale((double)dashStrength).add(user.getLookAngle().normalize().scale(Math.min(user.getDeltaMovement().length(), 7.5)).scale((double)0.4f)));
        this.playParticles((Entity)user, stack, dashes);
        this.damageItem((Entity)user, stack, slot, 2);
        this.setDashCount(stack, dashes + 1);
    }

    public void playParticles(Entity user, ItemStack stack, int dashes) {
        Vec3 particleSpeed = user.getDeltaMovement().scale((double)0.2f);
        for (int i = 0; i < 15; ++i) {
            user.level().addParticle(SparklingProperty.getParticles(stack).orElse(dashes < this.maxDashes - 1 ? CRYSTAL_PARTICLES : CLOUD_PARTICLES), user.getRandomX((double)1.2f), user.getY((double)(user.getRandom().nextFloat() * 0.6f)), user.getRandomZ((double)1.2f), particleSpeed.x(), particleSpeed.y(), particleSpeed.z());
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return this.colors[Math.min(this.colors.length - 1, this.getDashCount(stack))];
    }

    @Override
    public Tuple<Boolean, Integer> readData(CompoundTag tag) {
        return new Tuple((Object)tag.getBoolean("sprinting"), (Object)Math.clamp((long)tag.getInt("dash_count"), 0, this.maxDashes));
    }

    @Override
    public CompoundTag writeData(final Tuple<Boolean, Integer> data) {
        return new CompoundTag(this){
            {
                this.putBoolean("sprinting", (Boolean)data.getA());
                this.putInt("dash_count", (Integer)data.getB());
            }
        };
    }

    @Override
    public Tuple<Boolean, Integer> getDefaultData() {
        return DEFAULT;
    }
}

