/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FlameWakerProperty
extends Property {
    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (user.level().isClientSide() || slot != EquipmentSlot.FEET && slot != EquipmentSlot.BODY) {
            return;
        }
        Level level = user.level();
        BlockPos pos = user.blockPosition();
        BlockState state = level.getBlockState(pos);
        if (user.getKnownMovement().length() <= (double)0.005f && state.is(BlockTags.FIRE) && state.hasProperty((net.minecraft.world.level.block.state.properties.Property)FireBlock.AGE)) {
            level.setBlock(pos, (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)FireBlock.AGE, (Comparable)Integer.valueOf(Math.min((Integer)state.getValue((net.minecraft.world.level.block.state.properties.Property)FireBlock.AGE), 2))), 11);
        }
        if (user.isSprinting() && (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)Direction.UP) || level.getBlockState(pos).canBeReplaced())) {
            BlockState fireBlock = BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos);
            if (fireBlock.hasProperty((net.minecraft.world.level.block.state.properties.Property)FireBlock.AGE)) {
                fireBlock = (BlockState)fireBlock.setValue((net.minecraft.world.level.block.state.properties.Property)FireBlock.AGE, (Comparable)Integer.valueOf(8));
            }
            level.setBlock(pos, fireBlock, 11);
            if (user.tickCount % 40 == 0) {
                this.damageItem((Entity)user, stack, slot, 1);
            }
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 16740386;
    }
}

