/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.cibernet.alchemancy.client.particle.options.SparkParticleOptions;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.mixin.accessors.LivingEntityAccessor;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.registries.AlchemancyParticles;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class GustJetProperty
extends Property {
    private static final float PARTICLE_SCALE = 1.2f;
    public static final ParticleOptions PARTICLES = new SparkParticleOptions((ParticleType<SparkParticleOptions>)((ParticleType)AlchemancyParticles.GUST_DUST.get()), Vec3.fromRGB24((int)14739199).toVector3f(), 1.2f, false);

    @Override
    public void onItemUseTick(LivingEntity user, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
        EquipmentSlot slot;
        Level level = user.level();
        Vec3 eyePos = user.getEyePosition();
        float maxDistance = this.getMaxDistance(stack);
        double distance = level.clip(new ClipContext(eyePos, eyePos.add(user.getLookAngle().scale((double)maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)user)).getLocation().distanceTo(eyePos);
        double pow = Mth.lerp((double)Mth.clamp((double)(distance / (double)maxDistance), (double)0.0, (double)1.0), (double)0.35f, (double)0.085f);
        this.playEffects(level, user, stack, eyePos.add(user.getLookAngle()), user.getLookAngle(), (1.0 - distance / (double)maxDistance) * 1.5 + 0.75, (float)(distance / (double)maxDistance), 0.1f, 0.1f);
        Vec3 movementVector = user.getLookAngle().scale(pow);
        this.pushEntities(level, user, maxDistance, eyePos, user.getLookAngle(), stack);
        if (user.isShiftKeyDown() && user.onGround() || this.shouldPull(stack)) {
            return;
        }
        user.setDeltaMovement(user.getDeltaMovement().subtract(movementVector));
        user.hasImpulse = true;
        if (movementVector.y() > (double)0.005f) {
            user.fallDistance = Math.max(0.0f, user.fallDistance - 10.0f);
        }
        EquipmentSlot equipmentSlot = slot = user.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        if (event.getDuration() % 40 == 5) {
            this.damageOrConsumeItem((Entity)user, stack, slot, 1);
        }
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (user.isPassenger() || slot != EquipmentSlot.FEET && slot != EquipmentSlot.BODY) {
            return;
        }
        float maxDistance = this.getMaxDistance(stack);
        if (((LivingEntityAccessor)user).isJumping()) {
            Level level = user.level();
            Vec3 pos = user.position();
            Vec3 down = new Vec3(0.0, -1.0, 0.0);
            if (!level.isClientSide() && user.tickCount % 20 == 0) {
                this.damageOrConsumeItem((Entity)user, stack, slot, 2);
            }
            double distance = level.clip(new ClipContext(pos, pos.add(down.scale((double)maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)user)).getLocation().distanceTo(pos);
            double pow = Mth.lerp((double)Mth.clamp((double)(distance / (double)maxDistance), (double)0.0, (double)1.0), (double)0.25, (double)0.065f);
            Vec3 movementVector = down.scale(pow);
            this.playEffects(level, user, stack, pos, down, 1.0 - distance / (double)maxDistance, (float)(distance / (double)maxDistance), user.getBbWidth(), 0.0f);
            this.pushEntities(level, user, maxDistance, pos, down, stack);
            user.setDeltaMovement(user.getDeltaMovement().subtract(movementVector));
            user.hasImpulse = true;
            if (movementVector.y() > (double)0.005f) {
                user.fallDistance = Math.max(0.0f, user.fallDistance - 10.0f);
            }
            if (user.tickCount % 40 == 0) {
                this.damageOrConsumeItem((Entity)user, stack, slot, 1);
            }
        }
    }

    private void pushEntities(Level level, LivingEntity user, float pushDistance, Vec3 startPos, Vec3 angle, ItemStack stack) {
        List entities = level.getEntities((Entity)user, CommonUtils.boundingBoxAroundPoint(startPos, pushDistance), entity -> entity.position().distanceToSqr(startPos) <= (double)(pushDistance * pushDistance) && entity.position().vectorTo(user.position()).normalize().dot(angle) < -0.75);
        boolean pull = this.shouldPull(stack);
        for (Entity entity2 : entities) {
            Vec3 vec = pull ? entity2.position().subtract(startPos).normalize().scale(Mth.lerp((double)Mth.clamp((double)(entity2.position().distanceTo(startPos) / (double)pushDistance), (double)0.0, (double)1.0), (double)-0.15f, (double)-0.25)) : entity2.position().subtract(startPos).normalize().scale(Mth.lerp((double)Mth.clamp((double)(entity2.position().distanceTo(startPos) / (double)pushDistance), (double)0.0, (double)1.0), (double)0.35f, (double)0.85f));
            entity2.setDeltaMovement(user.getDeltaMovement().add(vec));
            entity2.hasImpulse = true;
            if (vec.y() > (double)0.005f) {
                entity2.fallDistance = Math.max(0.0f, user.fallDistance - 10.0f);
            }
            if (level.isClientSide() || !(user.getRandom().nextFloat() < 0.2f) || !(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            InfusedPropertiesHelper.forEachProperty(stack, propertyHolder -> ((Property)propertyHolder.value()).onAttack((Entity)user, stack, user.damageSources().generic(), living));
        }
    }

    private boolean shouldPull(ItemStack stack) {
        return InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.GRAPPLING);
    }

    private float getMaxDistance(ItemStack stack) {
        return InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.EXTENDED) ? 10.0f : 6.0f;
    }

    private void playEffects(Level level, LivingEntity user, ItemStack stack, Vec3 effectPosition, Vec3 movementVector, double pow, float soundPitch, float hOff, float vOff) {
        RandomSource random = user.getRandom();
        if (level.isClientSide()) {
            boolean particleSpeed = true;
            Optional<ParticleOptions> sparklingParticles = SparklingProperty.getParticles(stack);
            ArrayList propertyParticles = new ArrayList();
            InfusedPropertiesHelper.forEachProperty(stack, propertyHolder -> {
                if (!propertyHolder.is(AlchemancyTags.Properties.CHANGES_GUST_JET_WIND_COLOR)) {
                    return;
                }
                propertyParticles.add(new SparkParticleOptions((ParticleType<SparkParticleOptions>)((ParticleType)AlchemancyParticles.GUST_DUST.get()), Vec3.fromRGB24((int)((Property)propertyHolder.value()).getColor(stack)).toVector3f(), 1.2f, false));
            });
            for (int i = 0; i < random.nextInt(3) + 1; ++i) {
                ParticleOptions particles = sparklingParticles.orElse(propertyParticles.isEmpty() ? PARTICLES : (ParticleOptions)propertyParticles.get(user.getRandom().nextInt(propertyParticles.size())));
                level.addParticle(particles, effectPosition.x() + (double)((random.nextFloat() - 0.5f) * hOff), effectPosition.y() + (double)((random.nextFloat() - 0.5f) * vOff), effectPosition.z() + (double)((random.nextFloat() - 0.5f) * hOff), movementVector.x() * (double)particleSpeed + user.getDeltaMovement().x() + (double)(random.nextFloat() - 0.5f) * pow, movementVector.y() * (double)particleSpeed + user.getDeltaMovement().y() + (double)(random.nextFloat() - 0.5f) * pow, movementVector.z() * (double)particleSpeed + user.getDeltaMovement().z() + (double)(random.nextFloat() - 0.5f) * pow);
            }
        }
        if (random.nextFloat() > 0.15f) {
            level.playSound(null, (Entity)user, (SoundEvent)AlchemancySoundEvents.GUST_JET.value(), SoundSource.BLOCKS, 0.25f, soundPitch);
        }
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        event.getEntity().startUsingItem(event.getHand());
        event.setCancellationResult(InteractionResult.CONSUME);
        event.setCanceled(true);
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return current.isEmpty() && original == UseAnim.NONE ? Optional.of(UseAnim.BOW) : current;
    }

    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return 72000;
    }

    @Override
    public int getColor(ItemStack stack) {
        return 14739199;
    }
}

