/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class LivingBatteryProperty
extends Property {
    public static final int CONVERSION = 50;

    @Override
    public int onItemRepaired(ItemStack stack, int amount, int original) {
        int toCharge = amount - stack.getDamageValue();
        if (toCharge <= 0) {
            return amount;
        }
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap == null || !cap.canReceive()) {
            return amount;
        }
        return Math.max(0, amount - cap.receiveEnergy(toCharge * 50, false) / 50);
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(0.25f, 11857716, 11857716, 14875769);
    }
}

