/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.entangled.AbstractEntangledProperty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class QuantumShiftProperty
extends Property {
    @Override
    public void onStackedOverItem(ItemStack stack, ItemStack stackedOnItem, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (clickAction != ClickAction.SECONDARY || stackedOnItem.isEmpty()) {
            return;
        }
        AtomicBoolean cont = new AtomicBoolean(true);
        InfusedPropertiesHelper.forEachProperty(stackedOnItem, propertyHolder -> {
            Object patt0$temp;
            if (cont.get() && (patt0$temp = propertyHolder.value()) instanceof AbstractEntangledProperty) {
                AbstractEntangledProperty entangledProperty = (AbstractEntangledProperty)patt0$temp;
                stackedOnSlot.set(entangledProperty.shift(stackedOnItem, (Entity)player));
                cont.set(false);
                isCancelled.set(true);
            }
        });
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        super.onActivation(source, target, stack, damageSource);
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stackInSlot = living.getItemBySlot(slot);
                AtomicBoolean cont = new AtomicBoolean(true);
                InfusedPropertiesHelper.forEachProperty(stackInSlot, propertyHolder -> {
                    Object patt0$temp;
                    if (cont.get() && (patt0$temp = propertyHolder.value()) instanceof AbstractEntangledProperty) {
                        AbstractEntangledProperty entangledProperty = (AbstractEntangledProperty)patt0$temp;
                        living.setItemSlot(slot, entangledProperty.shift(stackInSlot, (Entity)living));
                        cont.set(false);
                    }
                });
            }
        } else if (target instanceof InfusedItemProjectile) {
            InfusedItemProjectile projectile = (InfusedItemProjectile)target;
            AtomicBoolean cont = new AtomicBoolean(true);
            InfusedPropertiesHelper.forEachProperty(projectile.getItem(), propertyHolder -> {
                Object patt0$temp;
                if (cont.get() && (patt0$temp = propertyHolder.value()) instanceof AbstractEntangledProperty) {
                    AbstractEntangledProperty entangledProperty = (AbstractEntangledProperty)patt0$temp;
                    projectile.setItem(entangledProperty.shift(projectile.getItem(), (Entity)projectile));
                    cont.set(false);
                }
            });
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 15073024;
    }
}

