/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.Optional;
import net.cibernet.alchemancy.mixin.accessors.LivingEntityAccessor;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyParticles;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class RocketPoweredProperty
extends Property {
    @Override
    public void onItemUseTick(LivingEntity user, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
        block4: {
            block5: {
                if (event.getDuration() % 20 == 6) {
                    EquipmentSlot slot = user.getUsedItemHand() == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                    this.damageOrConsumeItem((Entity)user, stack, slot, 2);
                }
                RocketPoweredProperty.playParticles((Entity)user, stack);
                user.moveRelative(user.isFallFlying() ? 0.05f : 0.2f, new Vec3(0.0, (double)((float)Math.cos((double)(user.getXRot() + 90.0f) * Math.PI / 180.0)), (double)((float)Math.sin((double)(user.getXRot() + 90.0f) * Math.PI / 180.0))));
                if (user.isFallFlying()) break block4;
                if (!(user instanceof Player)) break block5;
                Player player = (Player)user;
                if (player.getAbilities().flying) break block4;
            }
            user.setDeltaMovement(user.getDeltaMovement().add(0.0, user.getGravity() * 0.75, 0.0));
        }
        user.hasImpulse = true;
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.FEET && !user.isPassenger() && ((LivingEntityAccessor)user).isJumping()) {
            if (!user.level().isClientSide() && user.tickCount % 20 == 0) {
                this.damageOrConsumeItem((Entity)user, stack, slot, 2);
            }
            RocketPoweredProperty.playBootParticles((Entity)user, stack);
            user.moveRelative(0.125f, user.isFallFlying() ? new Vec3(0.0, (double)((float)Math.cos((double)(user.getXRot() + 90.0f) * Math.PI / 180.0)), (double)((float)Math.sin((double)(user.getXRot() + 90.0f) * Math.PI / 180.0))) : new Vec3(0.0, 1.0, 0.0));
            user.fallDistance *= 0.8f;
            user.hasImpulse = true;
        }
    }

    public static ParticleOptions getParticles(ItemStack stack) {
        return SparklingProperty.getParticles(stack).orElse((ParticleOptions)(stack.is(AlchemancyItems.BARRELS_WARHAMMER) ? (ParticleOptions)AlchemancyParticles.WARHAMMER_FLAME.get() : ParticleTypes.FLAME));
    }

    public static void playParticles(Entity source, ItemStack stack) {
        Vec3 pos = source.position();
        RandomSource randomSource = source.getRandom();
        source.level().addParticle(RocketPoweredProperty.getParticles(stack), pos.x() - Math.cos((double)(source.getXRot() + 90.0f) * Math.PI / 180.0) * (double)0.2f, source.getEyeY() - (double)0.2f, pos.z() - Math.sin((double)(source.getXRot() + 90.0f) * Math.PI / 180.0) * (double)0.2f, -source.getDeltaMovement().x * 0.5 + randomSource.nextGaussian() * 0.05, -source.getDeltaMovement().y * 0.5 + randomSource.nextGaussian() * 0.05, -source.getDeltaMovement().z * 0.5 + randomSource.nextGaussian() * 0.05);
    }

    public static void playBootParticles(Entity source, ItemStack stack) {
        Vec3 pos = source.position();
        RandomSource randomSource = source.getRandom();
        source.level().addParticle(RocketPoweredProperty.getParticles(stack), pos.x(), pos.y(), pos.z(), -source.getDeltaMovement().x * 0.5 + randomSource.nextGaussian() * 0.05, -source.getDeltaMovement().y * 0.5 + randomSource.nextGaussian() * 0.05, -source.getDeltaMovement().z * 0.5 + randomSource.nextGaussian() * 0.05);
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        event.getEntity().startUsingItem(event.getHand());
        event.setCancellationResult(InteractionResult.CONSUME);
        event.setCanceled(true);
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return current.isEmpty() && original == UseAnim.NONE ? Optional.of(UseAnim.BOW) : current;
    }

    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return 72000;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        return super.getDisplayText(stack).copy().withStyle(ChatFormatting.BOLD);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 14035498;
    }

    @Override
    public boolean hasJournalEntry() {
        return false;
    }
}

