/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import net.cibernet.alchemancy.network.S2CRotatePlayerPayload;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.InfusionPropertyDispenseBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class RotatingProperty
extends Property {
    @Override
    public InfusionPropertyDispenseBehavior.DispenseResult onItemDispense(BlockSource blockSource, Direction direction, ItemStack stack, InfusionPropertyDispenseBehavior.DispenseResult currentResult) {
        if (RotatingProperty.rotateBlock((Level)blockSource.level(), blockSource.pos().relative(direction), direction.getOpposite())) {
            return InfusionPropertyDispenseBehavior.DispenseResult.SUCCESS;
        }
        return currentResult;
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        if (face == null) {
            return;
        }
        if (RotatingProperty.rotateBlock(level, pos, face)) {
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static boolean rotateBlock(Level level, BlockPos pos, Direction face) {
        BlockState state = level.getBlockState(pos);
        BlockState newState = null;
        if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING) && state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING) != ((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING)).getClockWise(face.getAxis())) {
            newState = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING)).getClockWise(face.getAxis()));
        } else if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING)) {
            newState = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise());
        } else if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING_HOPPER)) {
            newState = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING_HOPPER, (Comparable)((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.FACING_HOPPER)).getClockWise());
        } else if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.AXIS)) {
            newState = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.AXIS, (Comparable)RotatingProperty.rotateAxis((Direction.Axis)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.AXIS), face.getAxis()));
        } else if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            newState = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.AXIS, (Comparable)RotatingProperty.rotateAxis((Direction.Axis)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.AXIS), Direction.Axis.Y));
        } else if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.ROTATION_16)) {
            newState = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(((Integer)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.ROTATION_16) + 1) % RotationSegment.getMaxSegmentIndex()));
        }
        if (newState != null && newState.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, newState, 3);
            return true;
        }
        return false;
    }

    private static Direction.Axis rotateAxis(Direction.Axis axis, Direction.Axis from) {
        if (from == Direction.Axis.X) {
            return switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> Direction.Axis.X;
                case Direction.Axis.Y -> Direction.Axis.Z;
                case Direction.Axis.Z -> Direction.Axis.Y;
            };
        }
        if (from == Direction.Axis.Y) {
            return switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> Direction.Axis.Z;
                case Direction.Axis.Y -> Direction.Axis.Y;
                case Direction.Axis.Z -> Direction.Axis.X;
            };
        }
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Direction.Axis.Y;
            case Direction.Axis.Y -> Direction.Axis.X;
            case Direction.Axis.Z -> Direction.Axis.Z;
        };
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player user = event.getEntity();
        double distance = user.entityInteractionRange();
        EntityHitResult hit = ProjectileUtil.getEntityHitResult((Entity)user, (Vec3)user.getEyePosition(), (Vec3)user.getEyePosition().add(user.getLookAngle().scale(distance)), (AABB)CommonUtils.boundingBoxAroundPoint(user.getEyePosition(), (float)distance), e -> !e.isSpectator(), (double)distance);
        if (hit == null) {
            return;
        }
        this.rotateEntity(hit.getEntity());
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        this.rotateEntity(event.getTarget());
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        this.rotateEntity(target);
    }

    private void rotateEntity(Entity target) {
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2CRotatePlayerPayload(45.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        float prevRot = target.getYRot();
        target.setYRot(prevRot - 45.0f);
        target.setYHeadRot(prevRot);
        target.setOnGround(false);
        target.hurtMarked = true;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            target.setYBodyRot(living.yBodyRot - 45.0f);
            living.setNoActionTime(60);
        }
        if (target instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)target;
            pathfinderMob.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
            pathfinderMob.targetSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0xFFF787;
    }
}

