/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import net.cibernet.alchemancy.properties.InteractableProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RunningStartProperty
extends Property
implements IDataHolder<Boolean> {
    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        Player player;
        super.onEquippedTick(user, slot, stack);
        if (!user.isSprinting()) {
            return;
        }
        if (!(!user.isSprinting() || ((Boolean)this.getData(stack)).booleanValue() || user instanceof Player && (player = (Player)user).getCooldowns().isOnCooldown(stack.getItem()))) {
            RunningStartProperty.activateByEntity((Entity)user, (Entity)user, stack);
            if (user instanceof Player) {
                Player player2 = (Player)user;
                InteractableProperty.applyCooldown(player2, stack, 80);
            }
        }
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (user.isSprinting()) {
            this.setData(stack, Boolean.valueOf(true));
        } else {
            this.removeData(stack);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 6029251;
    }

    @Override
    public Boolean readData(CompoundTag tag) {
        return tag.getBoolean("sprinting");
    }

    @Override
    public CompoundTag writeData(final Boolean data) {
        return new CompoundTag(this){
            {
                this.putBoolean("sprinting", data);
            }
        };
    }

    @Override
    public Boolean getDefaultData() {
        return false;
    }
}

