/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.special;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.cibernet.alchemancy.crafting.ForgePropertyRecipe;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.InnatePropertyItem;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.EnderProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.RotationDataProperty;
import net.cibernet.alchemancy.properties.WayfindingProperty;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.ClientUtil;
import net.cibernet.alchemancy.util.ColorUtils;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import org.jetbrains.annotations.Nullable;

public class WaywardWarpProperty
extends Property
implements IDataHolder<WayfindingProperty.WayfindData> {
    public static final Component DIMENSION_MISMATCH = Component.translatable((String)"property.alchemancy.wayward_warp.dimension_mismatch");
    public static final Component MISSING_DESTINATION = Component.translatable((String)"property.alchemancy.wayward_warp.missing_destination");
    public static final Component OBSTRUCTED_DESTINATION = Component.translatable((String)"property.alchemancy.wayward_warp.obstructed_destination");
    public static final InnatePropertyItem.Tooltip MEDALLION_TOOLTIP = (stack, context, tooltipComponents, tooltipFlag) -> {
        WayfindingProperty.WayfindData data = (WayfindingProperty.WayfindData)((WaywardWarpProperty)AlchemancyProperties.WAYWARD_WARP.value()).getData(stack);
        Level level = context.level();
        int color = ((WaywardWarpProperty)AlchemancyProperties.WAYWARD_WARP.value()).getColor(stack);
        if (level != null && level.isClientSide() && WaywardWarpProperty.hasDeathTracker((Entity)ClientUtil.getLocalPlayer(), stack)) {
            tooltipComponents.add(Component.translatable((String)"item.alchemancy.wayward_medallion.bound_to_death_point").withColor(ColorUtils.interpolateColorsOverTime(1.0f, color, ((RotationDataProperty)AlchemancyProperties.DEATH_TRACKER.get()).getColor(stack))));
        } else if (data.hasTarget()) {
            if (data.targetedPlayer().isPresent()) {
                Optional<Player> targetPlayer = CommonUtils.getPlayerByUUID((UUID)data.targetedPlayer().get().getA());
                tooltipComponents.add(Component.translatable((String)"item.alchemancy.wayward_medallion.bound_to_player", (Object[])new Object[]{targetPlayer.isPresent() ? targetPlayer.get().getGameProfile().getName() : data.targetedPlayer().get().getB()}).withColor(color));
            } else if (data.targetedPos().isPresent()) {
                GlobalPos pos = data.targetedPos().get();
                tooltipComponents.add(Component.translatable((String)"item.alchemancy.wayward_medallion.bound_to_position", (Object[])new Object[]{pos.pos().getX(), pos.pos().getY(), pos.pos().getZ()}).withColor(color));
                tooltipComponents.add(Component.translatable((String)"item.alchemancy.wayward_medallion.in", (Object[])new Object[]{pos.dimension().location().toString()}).withColor(color));
            }
        }
    };

    @Override
    public void onInfusedByForgeRecipe(ItemStack stack, ForgePropertyRecipe recipe, ForgeRecipeGrid grid) {
        super.onInfusedByForgeRecipe(stack, recipe, grid);
        WayfindingProperty.WayfindData wayfindData = (WayfindingProperty.WayfindData)((Tuple)((WayfindingProperty)AlchemancyProperties.WAYFINDING.get()).getData(stack)).getA();
        if (wayfindData.hasTarget()) {
            this.setData(stack, wayfindData);
        }
    }

    @Override
    public boolean onInfusedByDormantProperty(ItemStack stack, ItemStack propertySource, ForgeRecipeGrid grid, List<Holder<Property>> propertiesToAdd, boolean consumeItem) {
        WayfindingProperty.WayfindData wayfindData = (WayfindingProperty.WayfindData)((Tuple)((WayfindingProperty)AlchemancyProperties.WAYFINDING.get()).getData(stack)).getA();
        if (consumeItem && wayfindData.hasTarget()) {
            this.setData(stack, wayfindData);
        }
        return super.onInfusedByDormantProperty(stack, propertySource, grid, propertiesToAdd, consumeItem);
    }

    @Override
    public void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity;
        if (WaywardWarpProperty.hasDeathTracker((Entity)event.getEntity(), event.getItemStack())) {
            return;
        }
        WayfindingProperty.WayfindData data = (WayfindingProperty.WayfindData)this.getData(event.getItemStack());
        if (!data.hasTarget() && (entity = event.getTarget()) instanceof Player) {
            Player target = (Player)entity;
            this.setData(event.getItemStack(), data.withPlayer(target));
            WayfindingProperty.playWayfindingSound((Entity)target);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @Override
    public void onRightClickBlock(UseItemOnBlockEvent event) {
        if (!event.getLevel().getBlockState(event.getPos()).is(AlchemancyTags.Blocks.WAYFINDING_TARGETABLE) || WaywardWarpProperty.hasDeathTracker((Entity)event.getPlayer(), event.getItemStack())) {
            return;
        }
        WayfindingProperty.WayfindData data = (WayfindingProperty.WayfindData)this.getData(event.getItemStack());
        if (!data.hasTarget()) {
            this.setData(event.getItemStack(), data.withBlockPosition(new GlobalPos(event.getLevel().dimension(), event.getPos())));
            WayfindingProperty.playWayfindingSound(event.getLevel(), event.getPos());
            event.setCancellationResult(ItemInteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean hasDeathTracker(Entity user, ItemStack stack) {
        Player player;
        return InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.DEATH_TRACKER) && user instanceof Player && (player = (Player)user).getLastDeathLocation().isPresent();
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (WaywardWarpProperty.hasDeathTracker((Entity)event.getEntity(), event.getItemStack()) || ((WayfindingProperty.WayfindData)this.getData(event.getItemStack())).hasTarget()) {
            event.getEntity().startUsingItem(event.getHand());
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }

    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return Math.max(32, result);
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return current.isEmpty() && original == UseAnim.NONE ? Optional.of(UseAnim.BOW) : current;
    }

    @Override
    public boolean onFinishUsingItem(LivingEntity user, Level level, ItemStack stack) {
        return this.teleport(user, (Entity)user, level, stack);
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        LivingEntity living;
        this.teleport(source instanceof LivingEntity ? (living = (LivingEntity)source) : null, target, target.level(), stack);
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.SHATTERING) && rayTraceResult.getType() == HitResult.Type.ENTITY && rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            this.teleport(null, entityHitResult.getEntity(), projectile.level(), stack);
        }
    }

    public boolean teleport(@Nullable LivingEntity effectSource, Entity user, Level level, ItemStack stack) {
        Optional destination;
        Player player;
        if (level.isClientSide()) {
            return false;
        }
        WayfindingProperty.WayfindData data = (WayfindingProperty.WayfindData)this.getData(stack);
        boolean deathTracker = WaywardWarpProperty.hasDeathTracker((Entity)effectSource, stack);
        Optional<ResourceKey<Level>> targetDimension = data.getTargetDimension(level);
        Optional<BlockPos> targetPos = data.getTargetPos(level);
        if (!deathTracker && !data.hasTarget()) {
            return false;
        }
        if (deathTracker) {
            player = (Player)effectSource;
            targetDimension = Optional.of(((GlobalPos)player.getLastDeathLocation().get()).dimension());
            targetPos = Optional.of(((GlobalPos)player.getLastDeathLocation().get()).pos());
        }
        if (targetDimension.isPresent() && !targetDimension.get().location().equals((Object)user.level().dimension().location())) {
            if (user instanceof Player) {
                player = (Player)user;
                player.displayClientMessage(DIMENSION_MISMATCH, true);
            }
            return false;
        }
        if (!deathTracker && (targetPos.isEmpty() || data.targetedPos().isPresent() && !level.getBlockState(targetPos.get()).is(AlchemancyTags.Blocks.WAYFINDING_TARGETABLE))) {
            if (user instanceof Player) {
                player = (Player)user;
                player.displayClientMessage(MISSING_DESTINATION, true);
            }
            return false;
        }
        Optional optional = destination = deathTracker ? targetPos.map(BlockPos::getBottomCenter) : RespawnAnchorBlock.findStandUpPosition((EntityType)user.getType(), (CollisionGetter)user.level(), (BlockPos)targetPos.get());
        if (destination.isPresent()) {
            user.teleportTo(((Vec3)destination.get()).x, ((Vec3)destination.get()).y, ((Vec3)destination.get()).z);
            EnderProperty.playSound(level, (Vec3)destination.get());
            EnderProperty.playParticles(level, (Vec3)destination.get(), user.getRandom());
            EquipmentSlot slot = effectSource != null && effectSource.getUsedItemHand() == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            this.damageOrConsumeItem(user.level(), (Entity)effectSource, stack, slot, deathTracker ? 500 : 10);
            return true;
        }
        if (user instanceof Player) {
            Player player2 = (Player)user;
            player2.displayClientMessage(OBSTRUCTED_DESTINATION, true);
        }
        return false;
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(2.0f, -13075275, -3407622);
    }

    @Override
    public WayfindingProperty.WayfindData readData(CompoundTag tag) {
        return WayfindingProperty.WayfindData.fromNbt(tag);
    }

    @Override
    public CompoundTag writeData(WayfindingProperty.WayfindData data) {
        return data.toNbt();
    }

    @Override
    public WayfindingProperty.WayfindData getDefaultData() {
        return WayfindingProperty.WayfindData.DEFAULT;
    }

    @Override
    public boolean hasJournalEntry() {
        return false;
    }
}

