/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.voidborn;

import java.util.Collection;
import java.util.List;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public class BigSuckProperty
extends Property {
    @Override
    public boolean onFinishUsingItem(LivingEntity user, Level level, ItemStack stack) {
        this.suckBigly(level, (Entity)user);
        this.damageItem((Entity)user, stack, EquipmentSlot.MAINHAND, 20);
        return false;
    }

    @Override
    public void onActivation(@Nullable Entity source, Entity target, ItemStack stack, DamageSource damageSource) {
        if (target == source) {
            return;
        }
        this.suckBigly(target.level(), target);
        this.damageOrConsumeItem(target.level(), source, stack, EquipmentSlot.MAINHAND, 20);
    }

    @Override
    public void onActivationByBlock(Level level, BlockPos position, Entity target, ItemStack stack) {
        Level level2 = target.level();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level2;
        boolean pickUp = false;
        for (ItemEntity item2 : serverLevel.getEntities(EntityTypeTest.forClass(ItemEntity.class), item -> true)) {
            item2.moveTo(position.getBottomCenter());
            item2.setDeltaMovement(Vec3.ZERO);
            pickUp = true;
        }
        if (pickUp) {
            this.damageOrConsumeItem(level, null, stack, EquipmentSlot.MAINHAND, 20);
        }
    }

    private void suckBigly(Level level, Entity user) {
        block4: {
            if (!(level instanceof ServerLevel)) break block4;
            ServerLevel serverLevel = (ServerLevel)level;
            if (user instanceof Player) {
                Player player = (Player)user;
                for (ItemEntity item2 : serverLevel.getEntities(EntityTypeTest.forClass(ItemEntity.class), item -> true)) {
                    item2.playerTouch(player);
                }
            } else {
                for (ItemEntity item3 : serverLevel.getEntities(EntityTypeTest.forClass(ItemEntity.class), item -> true)) {
                    item3.moveTo(user.position());
                    item3.setDeltaMovement(Vec3.ZERO);
                }
            }
        }
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        Level level;
        if (projectile.isRemoved() || event.isCanceled() || !((level = projectile.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean pickedUp = false;
        for (ItemEntity item2 : serverLevel.getEntities(EntityTypeTest.forClass(ItemEntity.class), item -> true)) {
            item2.moveTo(rayTraceResult.getLocation());
            pickedUp = true;
        }
        if (pickedUp) {
            projectile.discard();
        }
    }

    @Override
    public Collection<ItemStack> populateCreativeTab(DeferredItem<Item> capsuleItem, Holder<Property> holder) {
        return List.of();
    }

    @Override
    public int getColor(ItemStack stack) {
        return 0xFF00FF;
    }
}

