/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.voidborn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.item.InnatePropertyItem;
import net.cibernet.alchemancy.item.components.PropertyModifierComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public class BlockVacuumProperty
extends Property
implements IDataHolder<Data> {
    public static final DustColorTransitionOptions PARTICLES = new DustColorTransitionOptions(Vec3.fromRGB24((int)15502328).toVector3f(), Vec3.fromRGB24((int)0).toVector3f(), 0.75f);
    public static final InnatePropertyItem.Tooltip TOOL_TOOLTIP = (stack, context, tooltipComponents, tooltipFlag) -> {
        Data data = (Data)((BlockVacuumProperty)AlchemancyProperties.WORLD_OBLITERATOR.value()).getData(stack);
        if (data.filterBlock() != null) {
            tooltipComponents.add(Component.translatable((String)"item.alchemancy.black_hole_tool.bound_to_block", (Object[])new Object[]{data.filterBlock().getName()}).withColor(((BlockVacuumProperty)AlchemancyProperties.WORLD_OBLITERATOR.value()).getColor(stack)));
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onStackedOverMe(ItemStack carriedItem, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (clickAction != ClickAction.SECONDARY) {
            return;
        }
        Data data = (Data)this.getData(stack);
        Item item = carriedItem.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (data.tag() == null || blockItem.getBlock().defaultBlockState().is(data.tag())) {
                this.setData(stack, new Data(data.tag(), blockItem.getBlock()));
                isCancelled.set(true);
                return;
            }
        }
        if (!carriedItem.isEmpty()) return;
        this.setData(stack, new Data(data.tag()));
        isCancelled.set(true);
    }

    @Override
    public boolean cluelessCanReset() {
        return false;
    }

    @Override
    public void onItemUseTick(LivingEntity user, ItemStack stack, LivingEntityUseItemEvent.Tick event) {
        Level level = event.getEntity().level();
        Data data = (Data)this.getData(event.getItem());
        if (level.isClientSide()) {
            return;
        }
        int radius = PropertyModifierComponent.getOrElse(stack, this.asHolder(), AlchemancyProperties.Modifiers.EFFECT_RADIUS, Float.valueOf(5.0f)).intValue();
        AABB aabb = new AABB(user.blockPosition()).inflate((double)radius);
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)user.blockPosition().offset(radius, radius, radius), (BlockPos)user.blockPosition().offset(-radius, -radius, -radius))) {
            if (!(user.blockPosition().distSqr((Vec3i)pos) <= (double)(radius * radius))) continue;
            validPos.add(new BlockPos((Vec3i)pos));
        }
        Collections.shuffle(validPos);
        if (!validPos.isEmpty()) {
            BlockPos pos = (BlockPos)validPos.getFirst();
            int durabilityConsumed = 0;
            int i = 5;
            while (i > 0 && pos != null) {
                validPos.removeFirst();
                BlockState state = level.getBlockState(pos);
                if (state.canEntityDestroy((BlockGetter)level, pos, (Entity)user) && state.getBlock().defaultDestroyTime() >= 0.0f && data.matches(state)) {
                    level.destroyBlock(pos, false, (Entity)event.getEntity());
                    ItemEntity itemEntity = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), state.getBlock().asItem().getDefaultInstance(), 0.0, 0.0, 0.0);
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                    ((ServerLevel)level).sendParticles((ParticleOptions)PARTICLES, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
                    --i;
                    ++durabilityConsumed;
                }
                pos = validPos.isEmpty() ? null : (BlockPos)validPos.getFirst();
            }
            if (durabilityConsumed > 0) {
                this.damageItem((Entity)user, stack, EquipmentSlot.MAINHAND, durabilityConsumed);
            }
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            for (ItemEntity item2 : level.getEntitiesOfClass(ItemEntity.class, aabb, item -> {
                BlockItem blockItem;
                Item patt0$temp = item.getItem().getItem();
                return patt0$temp instanceof BlockItem && data.matches((blockItem = (BlockItem)patt0$temp).getBlock().defaultBlockState());
            })) {
                item2.playerTouch(player);
            }
        }
    }

    @Override
    public int modifyUseDuration(ItemStack stack, int original, int result) {
        return 72000;
    }

    @Override
    public Optional<UseAnim> modifyUseAnimation(ItemStack stack, UseAnim original, Optional<UseAnim> current) {
        return Optional.of(UseAnim.BOW);
    }

    @Override
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        event.getEntity().startUsingItem(event.getHand());
        event.setCancellationResult(InteractionResult.CONSUME);
        event.setCanceled(true);
    }

    @Override
    public Collection<ItemStack> populateCreativeTab(DeferredItem<Item> capsuleItem, Holder<Property> holder) {
        return List.of();
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(4.0f, 15502328, 5192594);
    }

    @Override
    public Data readData(CompoundTag tag) {
        return new Data(tag);
    }

    @Override
    public CompoundTag writeData(Data data) {
        return data.save();
    }

    @Override
    public Data getDefaultData() {
        return Data.DEFAULT;
    }

    @Override
    public Component getDisplayText(ItemStack stack) {
        MutableComponent name = super.getDisplayText(stack).copy().withStyle(ChatFormatting.BOLD);
        Data data = (Data)this.getData(stack);
        if (data.filterBlock() != null) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, data.filterBlock().getName()}).withColor(this.getColor(stack));
        }
        if (data.tag() != null) {
            return Component.translatable((String)"property.detail", (Object[])new Object[]{name, "#%s".formatted(data.tag().toString())}).withColor(this.getColor(stack));
        }
        return name;
    }

    @Override
    public boolean hasJournalEntry() {
        return false;
    }

    public record Data(@Nullable TagKey<Block> tag, @Nullable Block filterBlock) {
        public static final Data DEFAULT = new Data(null, null);

        public Data(@Nullable TagKey<Block> tag) {
            this(tag, null);
        }

        public Data(CompoundTag nbt) {
            this((TagKey<Block>)(nbt.contains("tag", 8) ? TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("tag"))) : null), nbt.contains("block", 8) ? (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("block"))) : null);
        }

        public CompoundTag save() {
            return new CompoundTag(){
                {
                    if (tag != null) {
                        this.putString("tag", tag.location().toString());
                    }
                    if (filterBlock != null) {
                        this.putString("block", BuiltInRegistries.BLOCK.getKey((Object)filterBlock).toString());
                    }
                }
            };
        }

        public boolean matches(BlockState blockState) {
            if (this.filterBlock() != null) {
                return blockState.is(this.filterBlock());
            }
            if (this.tag() != null) {
                return blockState.is(this.tag());
            }
            return true;
        }
    }
}

