/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.voidborn;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.item.components.PropertyModifierComponent;
import net.cibernet.alchemancy.properties.AbstractTimerProperty;
import net.cibernet.alchemancy.properties.voidborn.BlockVacuumProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class VoidbornProperty
extends AbstractTimerProperty {
    public static final int MAX_TIME = 200;

    @Override
    public void onEntityItemTick(ItemStack stack, ItemEntity itemEntity) {
        this.tickEntity(stack, (Entity)itemEntity);
    }

    @Override
    public void onProjectileTick(ItemStack stack, Projectile projectile) {
        this.tickEntity(stack, (Entity)projectile);
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (VoidbornProperty.isBelowWorld((Entity)user)) {
            this.resetStartTimestamp(stack);
            this.damageOrConsumeItem((Entity)user, stack, slot, 20);
        }
        this.tickEntity(stack, (Entity)user);
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.AUXILIARY) && (!PropertyModifierComponent.getOrElse(stack, AlchemancyProperties.AUXILIARY, AlchemancyProperties.Modifiers.IGNORE_INFUSED, false).booleanValue() || InfusedPropertiesHelper.hasInnateProperty(stack, this.asHolder()))) {
            if (VoidbornProperty.isBelowWorld(user)) {
                VoidbornProperty.playEffects(user);
                this.resetStartTimestamp(stack);
                this.damageOrConsumeItem(user, stack, EquipmentSlot.CHEST, 20);
            }
            this.tickEntity(stack, user);
        }
    }

    public static void playEffects(Entity target) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)BlockVacuumProperty.PARTICLES, target.getX(), target.getY(0.5), target.getZ(), 30, (double)(target.getBbWidth() * 0.5f), (double)(target.getBbHeight() * 0.25f), (double)(target.getBbWidth() * 0.25f), 0.0);
        }
    }

    private void tickEntity(ItemStack stack, Entity entity) {
        long elapsedTime = this.getElapsedTime(stack);
        if (this.hasRecordedTimestamp(stack) && elapsedTime < 200L && !entity.isShiftKeyDown()) {
            float hScale = 0.45f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                hScale = 1.0f;
                living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 10, 0, false, false));
            } else {
                entity.setGlowingTag(true);
            }
            entity.setDeltaMovement(entity.getDeltaMovement().multiply((double)hScale, (double)0.45f, (double)hScale).add(0.0, 0.1 + (double)(0.5f * (1.0f - (float)this.getElapsedTime(stack) / 200.0f)), 0.0));
        } else if (this.hasRecordedTimestamp(stack)) {
            this.removeData(stack);
            if (!(entity instanceof LivingEntity)) {
                entity.setGlowingTag(false);
            }
        }
    }

    @Override
    public void onItemPickedUp(Player player, ItemStack stack, ItemEntity itemEntity) {
        this.removeData(stack);
    }

    @Override
    public void onIncomingDamageReceived(Entity user, ItemStack stack, EquipmentSlot slot, DamageSource source, LivingIncomingDamageEvent event) {
        if (source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean onEntityItemBelowWorld(ItemStack stack, ItemEntity itemEntity) {
        VoidbornProperty.playEffects((Entity)itemEntity);
        this.resetStartTimestamp(stack);
        return true;
    }

    public static boolean isBelowWorld(Entity entity) {
        return entity.getY() < (double)(entity.level().getMinBuildHeight() - 64);
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(1.0f, 1772571, 2621593, 7405733, 1772571, 2621593, 2621593, 1772571, 1772571, 7405733, 7405733, 7405733, 2621593, 1772571, 1772571);
    }
}

