/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties.voidborn;

import java.lang.runtime.SwitchBootstraps;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.voidborn.VoidbornProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import org.jetbrains.annotations.Nullable;

public class VoidtouchProperty
extends Property {
    public static final ResourceKey<DamageType> VOIDTOUCH_DAMAGE_KEY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"voidtouch"));

    @Override
    public void onAttack(@Nullable Entity user, ItemStack weapon, DamageSource damageSource, LivingEntity target) {
        this.destroyEntity((Entity)target, user);
        this.consumeItem(user, weapon, EquipmentSlot.MAINHAND);
    }

    @Override
    public void onProjectileImpact(ItemStack stack, Projectile projectile, HitResult rayTraceResult, ProjectileImpactEvent event) {
        if (!(rayTraceResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
        this.destroyEntity(entityHitResult.getEntity(), projectile.getOwner(), (Entity)projectile);
        if (event.isCanceled()) {
            this.consumeItem((Entity)projectile, stack, EquipmentSlot.MAINHAND);
        }
        projectile.discard();
    }

    public static DamageSource voidDamage(DamageSources damageSources, @Nullable Entity source, @Nullable Entity directEntity, Vec3 position) {
        return new DamageSource((Holder)damageSources.damageTypes.getHolderOrThrow(VOIDTOUCH_DAMAGE_KEY), source, directEntity, position);
    }

    private void destroyEntity(Entity target, @Nullable Entity user) {
        this.destroyEntity(target, user, user);
    }

    private void destroyEnderDragon(EnderDragon enderDragon, @Nullable Entity user, @Nullable Entity directSource) {
        enderDragon.hurt(VoidtouchProperty.voidDamage(enderDragon.damageSources(), user, directSource, directSource == null ? enderDragon.position() : directSource.position()), Float.MAX_VALUE);
        if (enderDragon.getDragonFight() != null) {
            enderDragon.getDragonFight().setDragonKilled(enderDragon);
        }
        enderDragon.discard();
    }

    private void destroyEntity(Entity target, @Nullable Entity user, @Nullable Entity directSource) {
        LivingEntity living;
        if (target.level().isClientSide() || target instanceof LivingEntity && InfusedPropertiesHelper.hasItemWithProperty(living = (LivingEntity)target, AlchemancyProperties.VOIDBORN, true)) {
            VoidbornProperty.playEffects(target);
            return;
        }
        Entity entity = target;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnderDragon.class, EnderDragonPart.class, Player.class}, (Object)entity, n)) {
            case 0: {
                EnderDragon enderDragon = (EnderDragon)entity;
                this.destroyEnderDragon(enderDragon, user, directSource);
                break;
            }
            case 1: {
                EnderDragonPart enderDragonPart = (EnderDragonPart)entity;
                this.destroyEnderDragon(enderDragonPart.parentMob, user, directSource);
                break;
            }
            case 2: {
                Player player = (Player)entity;
                target.hurt(VoidtouchProperty.voidDamage(target.damageSources(), user, directSource, directSource == null ? target.position() : directSource.position()), Float.MAX_VALUE);
                if (!player.isDeadOrDying()) break;
                player.discard();
                break;
            }
            default: {
                target.discard();
            }
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return ColorUtils.interpolateColorsOverTime(1.0f, 2556072, 4849778);
    }
}

