/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.registries;

import net.cibernet.alchemancy.blocks.blockentities.ItemStackHolderBlockEntity;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.registries.AlchemancyBlockEntities;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class AlchemancyCapabilities {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, side) -> {
            InvWrapper invWrapper;
            if (blockEntity instanceof ItemStackHolderBlockEntity) {
                ItemStackHolderBlockEntity pedestal = (ItemStackHolderBlockEntity)blockEntity;
                invWrapper = pedestal.wrapper;
            } else {
                invWrapper = null;
            }
            return invWrapper;
        }, new Block[]{(Block)AlchemancyBlocks.INFUSION_PEDESTAL.get(), (Block)AlchemancyBlocks.ALCHEMANCY_FORGE.get()});
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)AlchemancyBlockEntities.ROOTED_ITEM.get(), (blockEntity, direction) -> (IEnergyStorage)blockEntity.getItem().getCapability(Capabilities.EnergyStorage.ITEM));
        Item[] items = (Item[])BuiltInRegistries.ITEM.stream().toArray(Item[]::new);
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.BATTERY_POWERED) ? new ComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType)AlchemancyItems.Components.FE_STORAGE.get(), 10000) : null, (ItemLike[])items);
    }
}

