/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.registries;

import java.util.function.UnaryOperator;
import net.cibernet.alchemancy.entity.CustomFallingBlock;
import net.cibernet.alchemancy.entity.InfusedItemProjectile;
import net.cibernet.alchemancy.entity.InfusionFlask;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AlchemancyEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"alchemancy");
    public static final DeferredHolder<EntityType<?>, EntityType<InfusedItemProjectile>> ITEM_PROJECTILE = AlchemancyEntities.register("infused_item_projectile", InfusedItemProjectile::new, MobCategory.MISC, builder -> builder.sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final DeferredHolder<EntityType<?>, EntityType<CustomFallingBlock>> FALLING_BLOCK = AlchemancyEntities.register("falling_block", CustomFallingBlock::new, MobCategory.MISC, builder -> builder.sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(20));
    public static final DeferredHolder<EntityType<?>, EntityType<InfusionFlask>> INFUSION_FLASK = AlchemancyEntities.register("infusion_flask", InfusionFlask::new, MobCategory.MISC, builder -> builder.sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String key, EntityType.EntityFactory<T> factory, MobCategory category, UnaryOperator<EntityType.Builder<T>> params) {
        return REGISTRY.register(key, () -> ((EntityType.Builder)params.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(key));
    }
}

