/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ColorUtils {
    public static int interpolateColorsOverTime(float timePerColor, int ... colors) {
        float progress = (float)(System.currentTimeMillis() % ((long)(timePerColor * 1000.0f) * (long)colors.length)) / 1000.0f / timePerColor;
        return FastColor.ARGB32.lerp((float)(progress % 1.0f), (int)colors[(int)progress % colors.length], (int)colors[((int)progress + 1) % colors.length]);
    }

    public static int interpolateColorsAndWait(float lerpTime, float waitTime, int ... colors) {
        float progress = (float)(System.currentTimeMillis() % ((long)((lerpTime + waitTime) * 1000.0f) * (long)colors.length)) / 1000.0f / (lerpTime + waitTime);
        return FastColor.ARGB32.lerp((float)Math.min(1.0f, progress % 1.0f / (lerpTime / (lerpTime + waitTime))), (int)colors[(int)progress % colors.length], (int)colors[((int)progress + 1) % colors.length]);
    }

    public static int flashColorsOverTime(double time, int ... colors) {
        return colors[(int)Math.abs((double)System.currentTimeMillis() / time % (double)colors.length)];
    }

    public static int sineColorsOverTime(float time, int colorA, int colorB) {
        float partialSecond = (float)(System.currentTimeMillis() % (1000L * (long)time)) / 1000.0f;
        return FastColor.ARGB32.lerp((float)(Mth.sin((float)((float)Math.PI * 2 * (partialSecond / time))) * 0.5f + 0.5f), (int)colorA, (int)colorB);
    }

    public static String colorToHexString(int color) {
        return String.format("%06X", color).toUpperCase();
    }
}

