/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.cibernet.alchemancy.data.save.AlchemancyServerData;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.network.S2CTriggerEchoPacket;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyDataAttachments;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public record EchoEffect(Optional<ResourceKey<Level>> sourceLevel, Optional<UUID> sourceId, ItemStack sourceItem, Vec3 relativePos, float damage, EffectType type, long startTime, long triggerAtTimestamp) {
    static ResourceKey<DamageType> ECHO_DAMAGE_KEY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"echo"));
    public static final Codec<EchoEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).optionalFieldOf("source_level").forGetter(EchoEffect::sourceLevel), (App)Codec.STRING.xmap(UUID::fromString, UUID::toString).optionalFieldOf("source_id").forGetter(EchoEffect::sourceId), (App)ItemStack.CODEC.fieldOf("source_item").forGetter(EchoEffect::sourceItem), (App)Vec3.CODEC.fieldOf("relative_position").forGetter(EchoEffect::relativePos), (App)Codec.FLOAT.fieldOf("damage").forGetter(EchoEffect::damage), (App)Codec.STRING.xmap(EffectType::valueOf, Enum::name).fieldOf("type").forGetter(EchoEffect::type), (App)Codec.LONG.fieldOf("start_time").forGetter(EchoEffect::startTime), (App)Codec.LONG.fieldOf("trigger_at").forGetter(EchoEffect::triggerAtTimestamp)).apply((Applicative)instance, EchoEffect::new));

    public static void applyBlockEffectToEntity(Entity target, Level level, BlockPos source, ItemStack sourceItem, int duration) {
        ArrayList<EchoEffect> currentEffects = new ArrayList<EchoEffect>((Collection)target.getData(AlchemancyDataAttachments.ECHO_EFFECTS));
        Vec3 relative = source.getCenter();
        currentEffects.add(new EchoEffect(Optional.of(level.dimension()), Optional.empty(), sourceItem.copy(), relative, 0.0f, EffectType.BLOCK_ACTIVATE, AlchemancyServerData.getGlobalTimer(), AlchemancyServerData.getGlobalTimer() + (long)duration));
        target.setData(AlchemancyDataAttachments.ECHO_EFFECTS, currentEffects);
    }

    public static void applyEffectToEntity(Entity target, @Nullable Entity source, ItemStack sourceItem, Vec3 sourcePosition, float damage, int duration, EffectType type) {
        if (target.level().isClientSide() || sourceItem.isEmpty()) {
            return;
        }
        ArrayList<EchoEffect> currentEffects = new ArrayList<EchoEffect>((Collection)target.getData(AlchemancyDataAttachments.ECHO_EFFECTS));
        Vec3 relative = sourcePosition.subtract(target.position());
        EchoEffect echo = new EchoEffect(source == null ? Optional.empty() : Optional.of(source.level().dimension()), source == null ? Optional.empty() : Optional.of(source.getUUID()), sourceItem.copy(), relative, damage, type, AlchemancyServerData.getGlobalTimer(), AlchemancyServerData.getGlobalTimer() + (long)duration);
        currentEffects.add(echo);
        target.setData(AlchemancyDataAttachments.ECHO_EFFECTS, currentEffects);
    }

    public void triggerServerside(Entity target) {
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ServerLevel sourceLevel = this.sourceLevel().map(key -> level2.getServer().getLevel(key)).orElse(null);
        Entity user = sourceLevel == null ? null : (Entity)this.sourceId.map(arg_0 -> ((ServerLevel)sourceLevel).getEntity(arg_0)).orElse(null);
        AtomicReference<Float> damageRef = new AtomicReference<Float>(Float.valueOf(this.damage()));
        EchoEffect.trigger(target, (Level)level2, user, this.sourceItem(), this.relativePos(), this.type(), damageRef);
        float damage = damageRef.get().floatValue();
        if (damage > 0.0f) {
            target.hurt(EchoEffect.damageSource(user, target, this.relativePos()), damage);
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2CTriggerEchoPacket(Optional.ofNullable(user == null ? null : Integer.valueOf(user.getId())), this.sourceLevel(), this.sourceItem(), this.relativePos(), this.type()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static DamageSource damageSource(Entity user, Entity target, Vec3 relativePos) {
        return new DamageSource((Holder)target.damageSources().damageTypes.getHolderOrThrow(ECHO_DAMAGE_KEY), user, user, target.position().add(relativePos));
    }

    public static void trigger(Entity target, @Nullable Level sourceLevel, @Nullable Entity user, ItemStack sourceItem, Vec3 relativePos, EffectType type) {
        EchoEffect.trigger(target, sourceLevel, user, sourceItem, relativePos, type, new AtomicReference<Float>(Float.valueOf(0.0f)));
    }

    public static void trigger(Entity target, @Nullable Level sourceLevel, @Nullable Entity user, ItemStack sourceItem, Vec3 relativePos, EffectType type, AtomicReference<Float> damage) {
        InfusedPropertiesHelper.forEachProperty(sourceItem, propertyHolder -> {
            if (propertyHolder.equals(AlchemancyProperties.ECHOED)) {
                return;
            }
            switch (type.ordinal()) {
                case 2: {
                    Player player;
                    ((Property)propertyHolder.value()).onCriticalAttack(user instanceof Player ? (player = (Player)user) : null, sourceItem, target);
                    break;
                }
                case 0: {
                    if (!(target instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)target;
                    ((Property)propertyHolder.value()).onAttack(user, sourceItem, Property.activationDamageSource(target.level(), user, target.position().add(relativePos)), living);
                    break;
                }
                case 1: {
                    if (!(target instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)target;
                    LivingDamageEvent.Pre damageEvent = new LivingDamageEvent.Pre(living, new DamageContainer(EchoEffect.damageSource(user, target, relativePos), ((Float)damage.get()).floatValue()));
                    ((Property)propertyHolder.value()).modifyAttackDamage(user, sourceItem, damageEvent);
                    damage.set(Float.valueOf(damageEvent.getNewDamage()));
                    break;
                }
                case 3: {
                    ((Property)propertyHolder.value()).onActivation(user, target, sourceItem, Property.activationDamageSource(sourceLevel == null ? target.level() : sourceLevel, user, target.position().add(relativePos)));
                    break;
                }
                case 4: {
                    if (sourceLevel == null) break;
                    ((Property)propertyHolder.value()).onActivationByBlock(sourceLevel, new BlockPos((int)relativePos.x(), (int)relativePos.y(), (int)relativePos.z()), target, sourceItem);
                }
            }
        });
    }

    public static enum EffectType {
        ATTACK,
        DAMAGE,
        CRIT,
        ACTIVATE,
        BLOCK_ACTIVATE;

    }
}

