/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class InfusionPropertyDispenseBehavior
implements DispenseItemBehavior {
    final DispenseItemBehavior parent;

    public InfusionPropertyDispenseBehavior(DispenseItemBehavior parent) {
        this.parent = parent;
    }

    public ItemStack dispense(BlockSource blockSource, ItemStack item) {
        DispenseResult[] result = new DispenseResult[]{DispenseResult.PASS};
        Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
        InfusedPropertiesHelper.forEachProperty(item, propertyHolder -> {
            DispenseResult currentResult = ((net.cibernet.alchemancy.properties.Property)propertyHolder.value()).onItemDispense(blockSource, direction, item, result[0]);
            if (currentResult.ordinal() < result[0].ordinal()) {
                result[0] = currentResult;
            }
        });
        if (result[0] == DispenseResult.CONSUME) {
            item.shrink(1);
        }
        return result[0] != DispenseResult.PASS ? item : this.parent.dispense(blockSource, item);
    }

    public static DispenseResult executeItemBehavior(BlockSource blockSource, ItemStack stack, Item parentItem) {
        OptionalDispenseItemBehavior optionalDispenseItemBehavior;
        DispenseItemBehavior parentBehavior = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(parentItem);
        parentBehavior.dispense(blockSource, stack);
        return !(parentBehavior instanceof OptionalDispenseItemBehavior) || (optionalDispenseItemBehavior = (OptionalDispenseItemBehavior)parentBehavior).isSuccess() ? DispenseResult.SUCCESS : DispenseResult.PASS;
    }

    public static void playDefaultEffects(BlockSource blockSource, Direction direction) {
        InfusionPropertyDispenseBehavior.playDefaultSound(blockSource);
        InfusionPropertyDispenseBehavior.playDefaultParticles(blockSource, direction);
    }

    public static void playDefaultSound(BlockSource blockSource) {
        blockSource.level().levelEvent(1000, blockSource.pos(), 0);
    }

    public static void playDefaultParticles(BlockSource blockSource, Direction direction) {
        blockSource.level().levelEvent(2000, blockSource.pos(), direction.get3DDataValue());
    }

    public static enum DispenseResult {
        CONSUME,
        SUCCESS,
        PASS;

    }
}

