/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import java.util.ArrayList;
import net.cibernet.alchemancy.data.save.AlchemancyLevelData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class RedstoneSources {
    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RedstoneSources.tick(serverLevel);
        }
    }

    public static void createSourceAt(ServerLevel level, BlockPos pos, int power, int ticks, Direction direction) {
        if (level.getBlockState(pos).is(BlockTags.AIR)) {
            return;
        }
        AlchemancyLevelData data = AlchemancyLevelData.compute(level);
        data.getRedstoneSources().put(pos, new RedstoneSource(power, ticks, direction));
        data.setDirty();
        RedstoneSources.updateBlock(level, pos);
    }

    public static int getSourcePower(ServerLevel level, BlockPos pos) {
        return AlchemancyLevelData.compute((ServerLevel)level).getRedstoneSources().getOrDefault((Object)pos, (RedstoneSource)RedstoneSource.DEFAULT).power;
    }

    public static RedstoneSource getSourceAt(ServerLevel level, BlockPos pos) {
        return AlchemancyLevelData.compute(level).getRedstoneSources().getOrDefault(pos, RedstoneSource.DEFAULT);
    }

    public static void tick(ServerLevel level) {
        ArrayList<BlockPos> updates = new ArrayList<BlockPos>();
        AlchemancyLevelData data = AlchemancyLevelData.compute(level);
        data.getRedstoneSources().entrySet().removeIf(entry -> {
            if (((RedstoneSource)entry.getValue()).ticks-- < 0) {
                ((RedstoneSource)entry.getValue()).power = 0;
                updates.add((BlockPos)entry.getKey());
                data.setDirty();
                return true;
            }
            return false;
        });
        if (!updates.isEmpty()) {
            updates.forEach(pos -> RedstoneSources.updateBlock(level, pos));
        }
    }

    private static void updateBlock(ServerLevel level, BlockPos pos) {
        level.updateNeighborsAt(pos, level.getBlockState(pos).getBlock());
        level.neighborChanged(pos, Blocks.AIR, pos.above());
    }

    public static class RedstoneSource {
        public static final RedstoneSource DEFAULT = new RedstoneSource(0, 0, Direction.UP);
        public int power;
        public int ticks;
        public final Direction direction;

        public RedstoneSource(int power, int ticks, Direction direction) {
            this.power = power;
            this.ticks = ticks;
            this.direction = direction;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("power", this.power);
            tag.putInt("ticks", this.ticks);
            tag.putString("direction", this.direction.getName());
            return tag;
        }

        public static RedstoneSource read(CompoundTag tag) {
            return new RedstoneSource(tag.getInt("power"), tag.getInt("ticks"), Direction.byName((String)tag.getString("direction")));
        }
    }
}

