/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;

public class ShockUtils {
    static ResourceKey<DamageType> SHOCK_DAMAGE_KEY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"shock"));

    public static void selfDamagingMeleeShockAttack(Entity source, Vec3 position, float power) {
        ShockUtils.customShockAttack(source.level(), null, position, power, target -> ShockUtils.meleeShockDamage(source, position));
    }

    public static void meleeShockAttack(Entity source, Vec3 position, float power) {
        ShockUtils.customShockAttack(source.level(), source, position, power, target -> ShockUtils.meleeShockDamage(source, position));
    }

    public static void meleeShockAttack(Entity source, LivingEntity mainTarget, float power) {
        ShockUtils.customShockAttack(source.level(), source, mainTarget.position(), power, target -> ShockUtils.meleeShockDamage(source, target.position()));
    }

    public static void rangedShockAttack(Entity owner, Entity directSource, LivingEntity mainTarget, float power) {
        ShockUtils.customShockAttack(directSource.level(), directSource, mainTarget.position(), power, target -> ShockUtils.rangedShockDamage(owner, directSource, target));
    }

    public static void environmentalShockAttack(Level level, Vec3 position, float power) {
        ShockUtils.customShockAttack(level, null, position, power, target -> ShockUtils.environmentalShockDamage(level.damageSources(), position));
    }

    public static void customShockAttack(Level level, @Nullable Entity source, Vec3 position, float power, Function<LivingEntity, DamageSource> damageSourceSupplier) {
        ArrayList<Entity> immune = new ArrayList<Entity>();
        if (source != null) {
            immune.add(source);
        }
        ShockUtils.customShockAttack(level, source, position, power, damageSourceSupplier, immune);
    }

    private static void customShockAttack(Level level, @Nullable Entity source, Vec3 position, float power, Function<LivingEntity, DamageSource> damageSourceSupplier, ArrayList<Entity> alreadyAffected) {
        block10: {
            if (alreadyAffected.size() > 8) {
                return;
            }
            List candidates = level.getEntitiesOfClass(LivingEntity.class, CommonUtils.boundingBoxAroundPoint(position, Math.min(8.0f, power)), EntitySelector.NO_SPECTATORS.and(entity -> {
                LivingEntity living;
                return (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).isDeadOrDying()) && !alreadyAffected.contains(entity);
            }));
            candidates.sort(Comparator.comparingDouble(target -> target.distanceToSqr(position)));
            Iterator iterator = candidates.iterator();
            if (!iterator.hasNext()) break block10;
            LivingEntity target2 = (LivingEntity)iterator.next();
            float distanceTo = Mth.sqrt((float)((float)target2.distanceToSqr(position)));
            float damage = power - distanceTo * 0.5f;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!slot.isArmor() || !target2.getItemBySlot(slot).is(AlchemancyTags.Items.INCREASES_SHOCK_DAMAGE_RECEIVED)) continue;
                damage += power * 0.25f;
            }
            if (target2.isInWater()) {
                damage *= 1.5f;
            }
            if (damage <= 0.0f) {
                return;
            }
            Vec3 targetPos = target2.position().add(0.0, (double)(target2.getBbHeight() * 0.5f), 0.0);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int sparkSegments = (int)(power * 2.0f);
                if (distanceTo < target2.getBbWidth() * 0.5f) {
                    for (int i = 0; i < sparkSegments; ++i) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, target2.getRandomX(1.5), target2.getRandomY(), target2.getRandomZ(1.5), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    for (int i = 0; i < sparkSegments; ++i) {
                        Vec3 vec = targetPos.lerp(position, (double)i / (double)sparkSegments).offsetRandom(target2.getRandom(), 0.1f);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, vec.x, vec.y, vec.z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if ((damage -= 0.5f) <= 0.0f) {
                return;
            }
            target2.hurt(damageSourceSupplier.apply(target2), damage);
            alreadyAffected.add((Entity)target2);
            ShockUtils.customShockAttack(level, source, targetPos, damage, damageSourceSupplier, alreadyAffected);
        }
    }

    public static DamageSource shockDamage(DamageSources damageSources, @Nullable Entity source, @Nullable Entity directEntity, Vec3 position) {
        return new DamageSource((Holder)damageSources.damageTypes.getHolderOrThrow(SHOCK_DAMAGE_KEY), source, directEntity, position);
    }

    public static DamageSource rangedShockDamage(Entity source, Entity directEntity, @NonNull LivingEntity mainTarget) {
        return ShockUtils.shockDamage(directEntity.damageSources(), source, directEntity, mainTarget.position());
    }

    public static DamageSource meleeShockDamage(Entity source, Vec3 position) {
        return ShockUtils.shockDamage(source.damageSources(), source, source, position);
    }

    public static DamageSource environmentalShockDamage(DamageSources damageSources, Vec3 position) {
        return ShockUtils.shockDamage(damageSources, null, null, position);
    }
}

