/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import java.util.TreeMap;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtils {
    public static TreeMap<Direction, VoxelShape> createDirectionMap(VoxelShape shape) {
        TreeMap<Direction, VoxelShape> result = new TreeMap<Direction, VoxelShape>();
        for (Direction direction : Direction.values()) {
            result.put(direction, VoxelShapeUtils.rotate(shape, direction));
        }
        return result;
    }

    public static VoxelShape rotate(VoxelShape shape, Direction direction) {
        VoxelShape result = Shapes.empty();
        for (AABB part : shape.toAabbs()) {
            VoxelShape rotatedPart = switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.UP -> Shapes.create((AABB)part);
                case Direction.DOWN -> Shapes.box((double)part.minX, (double)(1.0 - part.maxY), (double)part.minZ, (double)part.maxX, (double)(1.0 - part.minY), (double)part.maxZ);
                case Direction.SOUTH -> Shapes.box((double)part.minX, (double)part.minZ, (double)part.minY, (double)part.maxX, (double)part.maxZ, (double)part.maxY);
                case Direction.NORTH -> Shapes.box((double)part.minX, (double)part.minZ, (double)(1.0 - part.maxY), (double)part.maxX, (double)part.maxZ, (double)(1.0 - part.minY));
                case Direction.EAST -> Shapes.box((double)part.minY, (double)part.minX, (double)part.minZ, (double)part.maxY, (double)part.maxX, (double)part.maxZ);
                case Direction.WEST -> Shapes.box((double)(1.0 - part.maxY), (double)part.minX, (double)part.minZ, (double)(1.0 - part.minY), (double)part.maxX, (double)part.maxZ);
            };
            result = Shapes.or((VoxelShape)result, (VoxelShape)rotatedPart);
        }
        return result;
    }
}

