/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WayfindingUtil {
    private static final CompassWobble wobble = new CompassWobble();
    private static final CompassWobble wobbleRandom = new CompassWobble();

    public static float getRotationTowardsCompassTarget(Entity entity, long ticks, BlockPos pos) {
        Player player;
        double d0 = WayfindingUtil.getAngleFromEntityToPos(entity, pos);
        double d1 = WayfindingUtil.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (wobble.shouldUpdate(ticks)) {
                wobble.update(ticks, 0.5 - (d1 - 0.25));
            }
            double d3 = d0 + WayfindingUtil.wobble.rotation;
            return Mth.positiveModulo((float)((float)d3), (float)1.0f);
        }
        double d2 = 0.5 - (d1 - 0.25 - d0);
        return Mth.positiveModulo((float)((float)d2), (float)1.0f);
    }

    public static float getRandomlySpinningRotation(int seed, long ticks) {
        if (wobbleRandom.shouldUpdate(ticks)) {
            wobbleRandom.update(ticks, Math.random());
        }
        double d0 = WayfindingUtil.wobbleRandom.rotation + (double)((float)WayfindingUtil.hash(seed) / 2.1474836E9f);
        return Mth.positiveModulo((float)((float)d0), (float)1.0f);
    }

    public static double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    public static double getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((double)(entity.getVisualRotationYInDegrees() / 360.0f), (double)1.0);
    }

    public static boolean shouldWobbleUpdate(long ticks) {
        return wobble.shouldUpdate(ticks);
    }

    private static int hash(int value) {
        return value * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CompassWobble {
        double rotation;
        double previousRotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long ticks) {
            return this.lastUpdateTick != ticks;
        }

        void update(long ticks, double rotation) {
            this.lastUpdateTick = ticks;
            double d0 = rotation - this.rotation;
            d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.previousRotation = this.rotation;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

