/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.block;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.block.WaystoneBlock;
import wraith.fwaystones.block.WaystoneDataPacket;
import wraith.fwaystones.item.AbyssWatcherItem;
import wraith.fwaystones.registry.BlockEntityRegistry;
import wraith.fwaystones.screen.WaystoneBlockScreenHandler;
import wraith.fwaystones.util.FWConfig;
import wraith.fwaystones.util.TeleportSources;
import wraith.fwaystones.util.Utils;

public class WaystoneBlockEntity
extends class_2621
implements class_1278,
ExtendedScreenHandlerFactory<WaystoneDataPacket>,
WaystoneValue {
    public float lookingRotR = 0.0f;
    private String name = "";
    private String hash;
    private boolean isGlobal = false;
    private UUID owner = null;
    private String ownerName = null;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
    private Integer color;
    private float turningSpeedR = 2.0f;
    private long tickDelta = 0L;

    public WaystoneBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.WAYSTONE_BLOCK_ENTITY, pos, state);
        this.name = Utils.generateWaystoneName(this.name);
    }

    public static void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, WaystoneBlockEntity waystone) {
        waystone.tick();
    }

    public static String createHashString(String dimensionName, class_2338 pos) {
        return Utils.getSHA256("<POS X:" + pos.method_10263() + ", Y:" + pos.method_10264() + ", Z:" + pos.method_10260() + ", WORLD: \">" + dimensionName + "\">");
    }

    public void updateActiveState() {
        if (this.field_11863 != null && !this.field_11863.field_9236 && (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)WaystoneBlock.ACTIVE) == (this.owner == null)) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)WaystoneBlock.ACTIVE, (Comparable)Boolean.valueOf(this.ownerName != null)));
            this.field_11863.method_8501(this.field_11867.method_10084(), (class_2680)this.field_11863.method_8320(this.field_11867.method_10084()).method_11657((class_2769)WaystoneBlock.ACTIVE, (Comparable)Boolean.valueOf(this.ownerName != null)));
        }
    }

    public void createHash(class_1937 world, class_2338 pos) {
        this.hash = WaystoneBlockEntity.createHashString(Utils.getDimensionName(world), pos);
        this.method_5431();
    }

    @Override
    public WaystoneBlockEntity getEntity() {
        return this;
    }

    @Override
    public int getColor() {
        if (this.color == null) {
            this.color = Utils.getRandomColor();
        }
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
        this.method_5431();
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new WaystoneBlockScreenHandler(syncId, this, player);
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return this.createMenu(syncId, playerInventory, playerInventory.field_7546);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.fwaystones.waystone");
    }

    protected class_2561 method_17823() {
        return this.method_5476();
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        if (nbt.method_10545("waystone_name")) {
            this.name = nbt.method_10558("waystone_name");
        }
        if (nbt.method_10545("waystone_is_global")) {
            this.isGlobal = nbt.method_10577("waystone_is_global");
        }
        if (nbt.method_10545("waystone_owner")) {
            this.owner = nbt.method_25926("waystone_owner");
        }
        if (nbt.method_10545("waystone_owner_name")) {
            this.ownerName = nbt.method_10558("waystone_owner_name");
        }
        this.color = nbt.method_10573("color", 3) ? Integer.valueOf(nbt.method_10550("color")) : null;
        this.inventory = class_2371.method_10213((int)nbt.method_10550("inventory_size"), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)lookup);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        this.createTag(nbt);
    }

    private void createTag(class_2487 tag) {
        tag.method_10582("waystone_name", this.name);
        if (this.owner != null) {
            tag.method_25927("waystone_owner", this.owner);
        }
        if (this.ownerName != null) {
            tag.method_10582("waystone_owner_name", this.ownerName);
        }
        tag.method_10556("waystone_is_global", this.isGlobal);
        if (this.color != null) {
            tag.method_10569("color", this.color.intValue());
        }
        tag.method_10569("inventory_size", this.inventory.size());
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)this.field_11863.method_30349());
    }

    public int method_5439() {
        return 0;
    }

    public void method_5431() {
        class_1937 class_19372;
        super.method_5431();
        if (this.field_11863 != null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public void setInventory(class_2371<class_1799> inventory) {
        this.inventory = inventory;
        this.method_5431();
    }

    public void setInventory(ArrayList<class_1799> newInventory) {
        this.inventory = class_2371.method_10213((int)newInventory.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < newInventory.size(); ++i) {
            this.setItemInSlot(i, newInventory.get(i));
        }
        this.method_5431();
    }

    private float rotClamp(int clampTo, float value) {
        if (value >= (float)clampTo) {
            return value - (float)clampTo;
        }
        if (value < 0.0f) {
            return value + (float)clampTo;
        }
        return value;
    }

    private boolean checkBound(int amount, float rot) {
        float Rot = Math.round(rot);
        float Rot2 = this.rotClamp(360, Rot + 180.0f);
        return Rot - (float)amount <= this.lookingRotR && this.lookingRotR <= Rot + (float)amount || Rot2 - (float)amount <= this.lookingRotR && this.lookingRotR <= Rot2 + (float)amount;
    }

    private void moveOnTickR(float rot) {
        if (!this.checkBound(2, rot)) {
            double check = (this.rotClamp(180, rot) - this.rotClamp(180, this.lookingRotR) + 180.0f) % 180.0f;
            this.lookingRotR = check < 90.0 ? (this.lookingRotR += this.turningSpeedR) : (this.lookingRotR -= this.turningSpeedR);
            this.lookingRotR = this.rotClamp(360, this.lookingRotR);
            if (this.checkBound(10, rot)) {
                this.turningSpeedR = 2.0f;
            } else {
                this.turningSpeedR += 1.0f;
                this.turningSpeedR = class_3532.method_15363((float)this.turningSpeedR, (float)2.0f, (float)20.0f);
            }
        }
    }

    private void addParticle(class_1657 player) {
        if (this.field_11863 == null) {
            return;
        }
        class_5819 r = this.field_11863.method_8409();
        class_243 playerPos = player.method_19538();
        class_2400 p = r.method_43048(10) > 7 ? class_2398.field_11215 : class_2398.field_11214;
        int j = r.method_43048(2) * 2 - 1;
        int k = r.method_43048(2) * 2 - 1;
        double y = this.method_11016().method_10264() + 1;
        int rd = r.method_43048(10);
        if (rd > 5) {
            if (p == class_2398.field_11215) {
                this.field_11863.method_8406((class_2394)p, playerPos.field_1352, playerPos.field_1351 + 1.5, playerPos.field_1350, (double)this.method_11016().method_10263() + 0.5 - playerPos.field_1352, y - 1.25 - playerPos.field_1351, (double)this.method_11016().method_10260() + 0.5 - playerPos.field_1350);
            } else {
                this.field_11863.method_8406((class_2394)p, (double)this.method_11016().method_10263() + 0.5, y + 0.8, (double)this.method_11016().method_10260() + 0.5, playerPos.field_1352 - (double)this.method_11016().method_10263() - r.method_43058(), playerPos.field_1351 - (double)this.method_11016().method_10264() - 0.5 - r.method_43058() * 0.5, playerPos.field_1350 - (double)this.method_11016().method_10260() - r.method_43058());
            }
        }
        if (rd > 8) {
            this.field_11863.method_8406((class_2394)p, y + 0.5, (double)this.method_11016().method_10264() + 0.8, (double)this.method_11016().method_10260() + 0.5, r.method_43058() * (double)j, (r.method_43058() - 0.25) * 0.125, r.method_43058() * (double)k);
        }
    }

    public void tick() {
        if (this.field_11863 == null) {
            return;
        }
        ++this.tickDelta;
        if (((Boolean)this.method_11010().method_11654((class_2769)WaystoneBlock.ACTIVE)).booleanValue()) {
            class_1657 closestPlayer = this.field_11863.method_18459((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 4.5, false);
            if (closestPlayer != null) {
                this.addParticle(closestPlayer);
                double x = closestPlayer.method_23317() - (double)this.method_11016().method_10263() - 0.5;
                double z = closestPlayer.method_23321() - (double)this.method_11016().method_10260() - 0.5;
                float rotY = (float)((double)((float)Math.atan2(z, x)) / Math.PI * 180.0 + 180.0);
                this.moveOnTickR(rotY);
            } else {
                this.lookingRotR += 2.0f;
            }
            this.lookingRotR = this.rotClamp(360, this.lookingRotR);
        }
        if (this.tickDelta >= 360L) {
            this.tickDelta = 0L;
        }
    }

    @Override
    public String getWaystoneName() {
        return this.name;
    }

    @Override
    public class_2338 way_getPos() {
        return this.method_11016();
    }

    @Override
    public String getWorldName() {
        return this.field_11863 == null ? "" : Utils.getDimensionName(this.field_11863);
    }

    public boolean canAccess(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean teleportPlayer(class_1657 player, boolean takeCost) {
        return this.teleportPlayer(player, takeCost, null);
    }

    public boolean teleportPlayer(class_1657 player, boolean takeCost, TeleportSources source) {
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 playerEntity = (class_3222)player;
        class_2350 facing = (class_2350)this.method_11010().method_11654(WaystoneBlock.FACING);
        float x = 0.0f;
        float z = 0.0f;
        float yaw = playerEntity.method_36454();
        switch (facing) {
            case field_11043: {
                x = 0.5f;
                z = -0.5f;
                yaw = 0.0f;
                break;
            }
            case field_11035: {
                x = 0.5f;
                z = 1.5f;
                yaw = 180.0f;
                break;
            }
            case field_11034: {
                x = 1.5f;
                z = 0.5f;
                yaw = 90.0f;
                break;
            }
            case field_11039: {
                x = -0.5f;
                z = 0.5f;
                yaw = 270.0f;
            }
        }
        float fX = x;
        float fZ = z;
        float fYaw = yaw;
        if (playerEntity.method_5682() == null) {
            return false;
        }
        class_5454 target = new class_5454((class_3218)this.method_10997(), new class_243((double)((float)this.field_11867.method_10263() + fX), (double)this.field_11867.method_10264(), (double)((float)this.field_11867.method_10260() + fZ)), new class_243(0.0, 0.0, 0.0), fYaw, 0.0f, class_5454.field_52247);
        if (source == null) {
            return false;
        }
        boolean teleported = this.doTeleport(playerEntity, (class_3218)this.field_11863, target, source, takeCost);
        if (!teleported) {
            return false;
        }
        if (!playerEntity.method_7337() && source == TeleportSources.ABYSS_WATCHER) {
            for (class_1268 hand : class_1268.values()) {
                class_1792 handItem = playerEntity.method_5998(hand).method_7909();
                if (!(handItem instanceof AbyssWatcherItem)) continue;
                player.method_20235(handItem, hand.equals((Object)class_1268.field_5808) ? class_1304.field_6173 : class_1304.field_6171);
                playerEntity.method_5998(hand).method_7934(1);
                player.method_37908().method_8396(null, this.field_11867, class_3417.field_15081, class_3419.field_15248, 1.0f, 1.0f);
                break;
            }
        }
        return true;
    }

    private boolean doTeleport(class_3222 player, class_3218 world, class_5454 target, TeleportSources source, boolean takeCost) {
        PlayerEntityMixinAccess playerAccess = (PlayerEntityMixinAccess)player;
        int cooldown = playerAccess.fabricWaystones$getTeleportCooldown();
        if (source != TeleportSources.VOID_TOTEM && cooldown > 0) {
            String cooldownSeconds = Utils.df.format((float)cooldown / 20.0f);
            player.method_7353((class_2561)class_2561.method_43469((String)"fwaystones.no_teleport_message.cooldown", (Object[])new Object[]{class_2561.method_43470((String)cooldownSeconds).method_27694(style -> style.method_27703((class_5251)class_5251.method_27719((String)class_2561.method_43471((String)"fwaystones.no_teleport_message.cooldown.arg_color").getString()).getOrThrow()))}), false);
            return false;
        }
        if (!Utils.canTeleport((class_1657)player, this.hash, source, takeCost)) {
            return false;
        }
        FWConfig.Teleportation_cooldown cooldowns = FabricWaystones.CONFIG.teleportation_cooldown;
        playerAccess.fabricWaystones$setTeleportCooldown(switch (source) {
            default -> throw new MatchException(null, null);
            case TeleportSources.WAYSTONE -> cooldowns.cooldown_ticks_from_waystone();
            case TeleportSources.ABYSS_WATCHER -> cooldowns.cooldown_ticks_from_abyss_watcher();
            case TeleportSources.LOCAL_VOID -> cooldowns.cooldown_ticks_from_local_void();
            case TeleportSources.VOID_TOTEM -> cooldowns.cooldown_ticks_from_void_totem();
            case TeleportSources.POCKET_WORMHOLE -> cooldowns.cooldown_ticks_from_pocket_wormhole();
        });
        class_2338 oldPos = player.method_24515();
        player.method_37908().method_8396(null, oldPos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
        player.method_18375();
        player.method_61275(target);
        class_2338 playerPos = player.method_24515();
        if (!oldPos.method_19771((class_2382)playerPos, 6.0) || !player.method_37908().method_27983().equals(world.method_27983())) {
            world.method_8396(null, playerPos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
        this.method_5431();
    }

    @Override
    public String getHash() {
        if (this.hash == null) {
            this.createHash(this.field_11863, this.field_11867);
        }
        return this.hash;
    }

    public byte[] getHashByteArray() {
        String hash = this.getHash();
        String[] values = hash.substring(1, hash.length() - 1).split(", ");
        byte[] bytes = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            bytes[i] = Byte.parseByte(values[i]);
        }
        return bytes;
    }

    public String getHexHash() {
        BigInteger number = new BigInteger(1, this.getHashByteArray());
        StringBuilder hexString = new StringBuilder(number.toString(16));
        while (hexString.length() < 32) {
            hexString.insert(0, '0');
        }
        return hexString.toString();
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
        this.method_5431();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(class_1657 player) {
        if (player == null) {
            if (this.owner != null && this.field_11863 != null) {
                this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), class_3417.field_26942, class_3419.field_15245, 1.0f, 1.0f);
                this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), class_3417.field_15210, class_3419.field_15245, 1.0f, 1.0f);
            }
            this.owner = null;
            this.ownerName = null;
        } else {
            if (this.owner == null && this.field_11863 != null) {
                this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), class_3417.field_14891, class_3419.field_15245, 1.0f, 1.0f);
                this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), class_3417.field_26944, class_3419.field_15245, 1.0f, 1.0f);
            }
            this.owner = player.method_5667();
            this.ownerName = player.method_5477().getString();
        }
        this.updateActiveState();
        this.method_5431();
    }

    public void toggleGlobal() {
        this.isGlobal = !this.isGlobal;
        this.method_5431();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setItemInSlot(int i, class_1799 itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public boolean hasStorage() {
        return !this.inventory.isEmpty();
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public WaystoneDataPacket getScreenOpeningData(class_3222 player) {
        return new WaystoneDataPacket(this.hash, this.name, this.owner, this.isGlobal, this.canAccess((class_1657)player), player.method_37908().field_9236, this.ownerName);
    }
}

