/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.util.Utils;

public final class WaystonesWorldgen {
    public static final HashMap<class_2960, class_2960> VANILLA_VILLAGES = new HashMap();
    public static final HashSet<class_2960> WAYSTONE_STRUCTURES = new HashSet();

    private WaystonesWorldgen() {
    }

    public static void registerVillage(MinecraftServer server, class_2960 village, class_2960 waystone) {
        if (FabricWaystones.CONFIG.worldgen.generate_in_villages()) {
            FabricWaystones.LOGGER.info("Adding waystone " + waystone.toString() + " to village " + village.toString());
            Utils.addToStructurePool(server, village, waystone, FabricWaystones.CONFIG.worldgen.village_waystone_weight());
        }
    }

    public static void registerVanillaVillageWorldgen(MinecraftServer server) {
        for (Map.Entry<class_2960, class_2960> entry : VANILLA_VILLAGES.entrySet()) {
            WaystonesWorldgen.registerVillage(server, entry.getKey(), entry.getValue());
        }
    }

    static {
        WAYSTONE_STRUCTURES.add(Utils.ID("desert_village_waystone"));
        WAYSTONE_STRUCTURES.add(Utils.ID("mossy_stone_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(Utils.ID("nether_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(Utils.ID("red_desert_village_waystone"));
        WAYSTONE_STRUCTURES.add(Utils.ID("red_nether_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(Utils.ID("stone_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(Utils.ID("village_waystone"));
        FabricWaystones.CONFIG.add_waystone_structure_piece().forEach((identifier, originalStructure) -> VANILLA_VILLAGES.put(class_2960.method_60654((String)identifier), Utils.ID(originalStructure)));
    }
}

