/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones;

import java.io.File;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wraith.fwaystones.packets.WaystonePacketHandler;
import wraith.fwaystones.registry.BlockEntityRegistry;
import wraith.fwaystones.registry.BlockRegistry;
import wraith.fwaystones.registry.CompatRegistry;
import wraith.fwaystones.registry.CustomScreenHandlerRegistry;
import wraith.fwaystones.registry.ItemRegistry;
import wraith.fwaystones.util.FWConfig;
import wraith.fwaystones.util.WaystoneStorage;
import wraith.fwaystones.util.WaystonesEventManager;

public class FabricWaystones
implements ModInitializer {
    public static final FWConfig CONFIG;
    public static final Logger LOGGER;
    public static final String MOD_ID = "fwaystones";
    public static WaystoneStorage WAYSTONE_STORAGE;

    public void onInitialize() {
        LOGGER.info("Is initializing.");
        BlockRegistry.registerBlocks();
        BlockEntityRegistry.registerBlockEntities();
        ItemRegistry.init();
        CompatRegistry.init();
        CustomScreenHandlerRegistry.registerScreenHandlers();
        WaystonesEventManager.registerEvents();
        WaystonePacketHandler.registerPackets();
        WaystonePacketHandler.registerPacketHandlers();
        LOGGER.info("Has successfully been initialized.");
    }

    static {
        LOGGER = LogManager.getLogger((String)"Fabric-Waystones");
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "fwaystones/config.json");
        if (configFile.exists()) {
            LOGGER.info("Old config file found, migrating...");
            configFile.renameTo(new File(FabricLoader.getInstance().getConfigDir().toFile(), "fwaystones/config.json5"));
        }
        CONFIG = FWConfig.createAndLoad();
    }
}

