/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.integration.journeymap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.event.FullscreenDisplayEvent;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.client.option.BooleanOption;
import journeymap.api.v2.client.option.OptionCategory;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.integration.event.WaystoneEvents;

@JourneyMapPlugin(apiVersion="2.0.0")
public class JourneymapPlugin
implements IClientPlugin {
    private final List<String> queuedWaypoints;
    private IClientAPI api = null;
    private BooleanOption enabled;
    private BooleanOption displayWaypoints;
    private boolean mappingStarted = false;
    private final Map<String, String> waypointHashes = new HashMap<String, String>();

    public JourneymapPlugin() {
        this.queuedWaypoints = new ArrayList<String>();
    }

    public void initialize(@NotNull IClientAPI api) {
        this.api = api;
        ClientEventRegistry.OPTIONS_REGISTRY_EVENT_EVENT.subscribe(this.getModId(), event -> {
            OptionCategory category = new OptionCategory(this.getModId(), "fwaystones.integration.journeymap.category");
            this.enabled = new BooleanOption(category, "enabled", "fwaystones.integration.journeymap.enable", Boolean.valueOf(true));
            this.displayWaypoints = new BooleanOption(category, "displayed", "fwaystones.integration.journeymap.enable", Boolean.valueOf(true));
        });
        ClientEventRegistry.MAPPING_EVENT.subscribe(this.getModId(), event -> {
            if (event.getStage().equals((Object)MappingEvent.Stage.MAPPING_STARTED)) {
                this.mappingStarted = true;
                this.buildQueuedWaypoints();
            } else {
                this.mappingStarted = false;
                api.removeAll(this.getModId());
            }
        });
        ClientEventRegistry.ADDON_BUTTON_DISPLAY_EVENT.subscribe(this.getModId(), this::onFullscreenAddonButton);
        WaystoneEvents.REMOVE_WAYSTONE_EVENT.register(this::onRemove);
        WaystoneEvents.DISCOVER_WAYSTONE_EVENT.register(this::onDiscover);
        WaystoneEvents.RENAME_WAYSTONE_EVENT.register(this::onRename);
        WaystoneEvents.FORGET_ALL_WAYSTONES_EVENT.register(player -> api.removeAll(this.getModId()));
    }

    private void onFullscreenAddonButton(FullscreenDisplayEvent.AddonButtonDisplayEvent addonButtonDisplayEvent) {
        addonButtonDisplayEvent.getThemeButtonDisplay().addThemeToggleButton("fwaystones.integration.journeymap.theme.on", "fwaystones.integration.journeymap.theme.off", class_2960.method_60654((String)"fabric_waystones_icon"), ((Boolean)this.displayWaypoints.get()).booleanValue(), b -> {
            b.toggle();
            this.displayWaypoints.set((Object)b.getToggled());
            this.updateWaypointDisplay(b.getToggled());
        });
    }

    public String getModId() {
        return "fwaystones";
    }

    private void updateWaypointDisplay(boolean display) {
        if (!display) {
            this.api.removeAll(this.getModId());
        } else {
            FabricWaystones.WAYSTONE_STORAGE.getAllHashes().forEach(this::addWaypoint);
        }
    }

    private void buildQueuedWaypoints() {
        this.queuedWaypoints.forEach(this::addWaypoint);
        this.queuedWaypoints.clear();
    }

    private void onRemove(String hash) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        Waypoint waypoint = this.api.getWaypoint(this.getModId(), this.waypointHashes.get(hash));
        if (waypoint != null) {
            this.api.removeWaypoint(this.getModId(), waypoint);
        }
    }

    private void onDiscover(String hash) {
        if (FabricWaystones.WAYSTONE_STORAGE == null) {
            return;
        }
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (this.mappingStarted) {
            this.addWaypoint(hash);
        } else {
            this.queuedWaypoints.add(hash);
        }
    }

    private void onRename(String hash) {
        this.onRemove(hash);
        this.addWaypoint(hash);
    }

    private void addWaypoint(String hash) {
        String waypointId = this.waypointHashes.get(hash);
        if (FabricWaystones.WAYSTONE_STORAGE == null || this.api.getWaypoint(this.getModId(), waypointId) != null) {
            return;
        }
        WaystoneValue waystone = FabricWaystones.WAYSTONE_STORAGE.getWaystoneData(hash);
        if (waystone == null) {
            return;
        }
        Waypoint waypoint = WaypointFactory.createClientWaypoint((String)this.getModId(), (class_2338)waystone.way_getPos(), (String)(Strings.isNullOrEmpty((String)waystone.getWaystoneName()) ? "Unnamed Waystone" : waystone.getWaystoneName()), (String)waystone.getWorldName(), (boolean)false);
        waypoint.setIconResourceLoctaion(class_2960.method_60654((String)"images/fabric_waystones_icon.png"));
        this.waypointHashes.put(hash, waypoint.getId());
        try {
            waypoint.setColor(waystone.getColor());
            waypoint.setEnabled(((Boolean)this.displayWaypoints.get()).booleanValue());
            this.api.addWaypoint(this.getModId(), waypoint);
        }
        catch (Throwable t) {
            FabricWaystones.LOGGER.error(t.getMessage(), t);
        }
    }
}

