/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.packets;

import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_8710;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.block.WaystoneBlock;
import wraith.fwaystones.block.WaystoneBlockEntity;
import wraith.fwaystones.packets.ForgetWaystonePacket;
import wraith.fwaystones.packets.RemoveWaystoneOwnerPacket;
import wraith.fwaystones.packets.RenameWaystonePacket;
import wraith.fwaystones.packets.RequestPlayerSyncPacket;
import wraith.fwaystones.packets.SyncPlayerFromClientPacket;
import wraith.fwaystones.packets.TeleportToWaystonePacket;
import wraith.fwaystones.packets.ToggleGlobalWaystonePacket;
import wraith.fwaystones.packets.WaystoneGUISlotClickPacket;
import wraith.fwaystones.packets.client.SyncPlayerPacket;
import wraith.fwaystones.packets.client.VoidRevivePacket;
import wraith.fwaystones.packets.client.WaystonePacket;
import wraith.fwaystones.util.FWConfigModel;

public final class WaystonePacketHandler {
    private WaystonePacketHandler() {
    }

    public static void registerPackets() {
        PayloadTypeRegistry.playC2S().register(RemoveWaystoneOwnerPacket.PACKET_ID, RemoveWaystoneOwnerPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(WaystoneGUISlotClickPacket.PACKET_ID, WaystoneGUISlotClickPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ForgetWaystonePacket.PACKET_ID, ForgetWaystonePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RenameWaystonePacket.PACKET_ID, RenameWaystonePacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(RequestPlayerSyncPacket.PACKET_ID, RequestPlayerSyncPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ToggleGlobalWaystonePacket.PACKET_ID, ToggleGlobalWaystonePacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(TeleportToWaystonePacket.PACKET_ID, TeleportToWaystonePacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(SyncPlayerFromClientPacket.PACKET_ID, SyncPlayerFromClientPacket.CODEC);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            WaystonePacketHandler.registerClientPackets();
        }
    }

    public static void registerClientPackets() {
        PayloadTypeRegistry.playS2C().register(SyncPlayerPacket.PACKET_ID, SyncPlayerPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(VoidRevivePacket.PACKET_ID, VoidRevivePacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(WaystonePacket.PACKET_ID, WaystonePacket.CODEC);
    }

    public static void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)ForgetWaystonePacket.PACKET_ID, WaystonePacketHandler::handleForgetWaystonePacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)RemoveWaystoneOwnerPacket.PACKET_ID, WaystonePacketHandler::handleRemoveWaystoneOwnerPacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)RenameWaystonePacket.PACKET_ID, WaystonePacketHandler::handleRenameWaystonePacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)RequestPlayerSyncPacket.PACKET_ID, WaystonePacketHandler::handleRequestPlayerSyncPacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)SyncPlayerFromClientPacket.PACKET_ID, WaystonePacketHandler::handleSyncPlayerFromClientPacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)TeleportToWaystonePacket.PACKET_ID, WaystonePacketHandler::handleTeleportToWaystonePacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)ToggleGlobalWaystonePacket.PACKET_ID, WaystonePacketHandler::handleToggleGlobalWaystonePacket);
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)WaystoneGUISlotClickPacket.PACKET_ID, WaystonePacketHandler::handleWaystoneGUISlotClickPacket);
    }

    public static void handleForgetWaystonePacket(ForgetWaystonePacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (FabricWaystones.WAYSTONE_STORAGE.removeIfInvalid(payload.waystoneHash())) {
                return;
            }
            context.server().execute(() -> ((PlayerEntityMixinAccess)context.player()).fabricWaystones$forgetWaystone(payload.waystoneHash()));
        });
    }

    public static void handleRemoveWaystoneOwnerPacket(RemoveWaystoneOwnerPacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            String hash = payload.waystone();
            UUID owner = payload.owner();
            if (FabricWaystones.WAYSTONE_STORAGE.removeIfInvalid(hash)) {
                return;
            }
            if (context.player().method_5667().equals(owner) || context.player().method_5687(2)) {
                FabricWaystones.WAYSTONE_STORAGE.setOwner(hash, null);
            }
        });
    }

    public static void handleRenameWaystonePacket(RenameWaystonePacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (FabricWaystones.WAYSTONE_STORAGE.removeIfInvalid(payload.waystone())) {
                return;
            }
            if (FabricWaystones.WAYSTONE_STORAGE.containsHash(payload.waystone()) && (context.player().method_5667().equals(payload.owner()) && payload.owner().equals(FabricWaystones.WAYSTONE_STORAGE.getWaystoneEntity(payload.waystone()).getOwner()) || context.player().method_5687(2))) {
                FabricWaystones.WAYSTONE_STORAGE.renameWaystone(payload.waystone(), payload.name());
            }
        });
    }

    public static void handleWaystoneGUISlotClickPacket(WaystoneGUISlotClickPacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (context.player().field_7512.field_7763 == payload.syncId()) {
                context.player().field_7512.method_7604((class_1657)context.player(), payload.clickedSlot());
            }
        });
    }

    public static void handleRequestPlayerSyncPacket(RequestPlayerSyncPacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(((PlayerEntityMixinAccess)context.player())::fabricWaystones$syncData);
    }

    public static void handleSyncPlayerFromClientPacket(SyncPlayerFromClientPacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> ((PlayerEntityMixinAccess)context.player()).fabricWaystones$fromTagW(payload.tag()));
    }

    public static void handleTeleportToWaystonePacket(TeleportToWaystonePacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (FabricWaystones.WAYSTONE_STORAGE.removeIfInvalid(payload.waystone())) {
                return;
            }
            WaystoneBlockEntity waystone = FabricWaystones.WAYSTONE_STORAGE.getWaystoneEntity(payload.waystone());
            if (waystone.method_10997() != null && !(waystone.method_10997().method_8320(waystone.method_11016()).method_26204() instanceof WaystoneBlock)) {
                FabricWaystones.WAYSTONE_STORAGE.removeWaystone(payload.waystone());
                waystone.method_10997().method_8544(waystone.method_11016());
            } else {
                waystone.teleportPlayer((class_1657)context.player(), true, payload.getSource());
            }
        });
    }

    public static void handleToggleGlobalWaystonePacket(ToggleGlobalWaystonePacket payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (FabricWaystones.WAYSTONE_STORAGE.removeIfInvalid(payload.waystone())) {
                return;
            }
            FWConfigModel.PermissionLevel permissionLevel = FabricWaystones.CONFIG.global_mode_toggle_permission_levels();
            switch (permissionLevel) {
                case NONE: {
                    return;
                }
                case OP: {
                    if (context.player().method_5687(2)) break;
                    return;
                }
                case OWNER: {
                    if (context.player().method_5667().equals(payload.owner()) && payload.owner().equals(FabricWaystones.WAYSTONE_STORAGE.getWaystoneEntity(payload.waystone()).getOwner())) break;
                    return;
                }
            }
            if (FabricWaystones.WAYSTONE_STORAGE.containsHash(payload.waystone())) {
                FabricWaystones.WAYSTONE_STORAGE.toggleGlobal(payload.waystone());
            }
        });
    }
}

