/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.screen;

import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.block.WaystoneBlockEntity;
import wraith.fwaystones.registry.CustomScreenHandlerRegistry;
import wraith.fwaystones.screen.UniversalWaystoneScreenHandler;
import wraith.fwaystones.util.WaystonePacketHandler;

public class WaystoneBlockScreenHandler
extends UniversalWaystoneScreenHandler {
    private final boolean isClient;
    private String name;
    private String hash;
    private UUID owner;
    private boolean isGlobal;
    private Function<class_1657, Boolean> canUse = null;
    private String ownerName = "";

    public WaystoneBlockScreenHandler(int syncId, WaystoneBlockEntity waystoneEntity, class_1657 player) {
        super((class_3917<? extends UniversalWaystoneScreenHandler>)CustomScreenHandlerRegistry.WAYSTONE_SCREEN, syncId, player);
        this.hash = waystoneEntity.getHash();
        this.name = waystoneEntity.getWaystoneName();
        this.owner = waystoneEntity.getOwner();
        this.isGlobal = waystoneEntity.isGlobal();
        this.canUse = waystoneEntity::canAccess;
        this.isClient = player.field_6002.field_9236;
        this.ownerName = waystoneEntity.getOwnerName();
        this.updateWaystones(player);
    }

    public WaystoneBlockScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        super((class_3917<? extends UniversalWaystoneScreenHandler>)CustomScreenHandlerRegistry.WAYSTONE_SCREEN, syncId, playerInventory.field_7546);
        this.isClient = playerInventory.field_7546.field_6002.field_9236;
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            this.hash = tag.method_10558("waystone_hash");
            this.name = tag.method_10558("waystone_name");
            if (tag.method_10545("waystone_owner")) {
                this.owner = tag.method_25926("waystone_owner");
            }
            if (tag.method_10545("waystone_owner_name")) {
                this.ownerName = tag.method_10558("waystone_owner_name");
            }
            this.isGlobal = tag.method_10577("waystone_is_global");
        }
        this.updateWaystones(this.player);
    }

    @Override
    public void onForget(String waystone) {
        if (this.hash.equals(waystone)) {
            this.closeScreen();
        }
    }

    @Override
    public void updateWaystones(class_1657 player) {
        super.updateWaystones(player);
        if (!player.field_6002.field_9236) {
            return;
        }
        if (!FabricWaystones.WAYSTONE_STORAGE.containsHash(this.hash)) {
            this.closeScreen();
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.canUse != null ? this.canUse.apply(player) : true;
    }

    public String getWaystone() {
        return this.hash;
    }

    public void toggleGlobal() {
        if (!this.isClient) {
            return;
        }
        class_2540 packet = PacketByteBufs.create();
        class_2487 tag = new class_2487();
        tag.method_10582("waystone_hash", this.hash);
        if (this.owner != null) {
            tag.method_25927("waystone_owner", this.owner);
        }
        packet.method_10794(tag);
        ClientPlayNetworking.send((class_2960)WaystonePacketHandler.TOGGLE_GLOBAL_WAYSTONE, (class_2540)packet);
        this.isGlobal = !this.isGlobal;
    }

    public boolean isOwner(class_1657 player) {
        return this.owner != null && this.owner.equals(player.method_5667());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return this.ownerName == null ? "" : this.ownerName;
    }

    public void removeOwner() {
        this.owner = null;
        this.ownerName = null;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }
}

