/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import wraith.waystones.Waystones;
import wraith.waystones.access.PlayerEntityMixinAccess;
import wraith.waystones.block.WaystoneBlock;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.mixin.MinecraftServerAccessor;
import wraith.waystones.util.WaystoneStorage;

public class CompatibilityLayer {
    private final WaystoneStorage STORAGE;
    private final ConcurrentHashMap<String, HashSet<String>> COMPATABILITY_MAP = new ConcurrentHashMap();
    private boolean COMPATABILITY_ENABLED = false;
    private final MinecraftServer SERVER;
    private static final String OLD_ID = "waystones_waystones";

    public CompatibilityLayer(WaystoneStorage storage, MinecraftServer server) {
        this.SERVER = server;
        this.STORAGE = storage;
    }

    public boolean loadCompatibility() {
        class_18 compatState = this.SERVER.method_3847(class_3218.field_25179).method_17983().method_20786(nbtCompound -> {
            this.fromTag((class_2487)nbtCompound);
            return new class_18(){

                public class_2487 method_75(class_2487 nbt) {
                    return CompatibilityLayer.this.writeNbt(nbt);
                }
            };
        }, OLD_ID);
        File worldDirectory = ((MinecraftServerAccessor)this.SERVER).getSession().method_27424(this.SERVER.method_30002().method_27983()).toFile();
        File file = new File(worldDirectory, "data/waystones_waystones.dat");
        if (file.exists()) {
            file.renameTo(new File(worldDirectory, "data/old_id_converted.dat"));
        }
        return compatState != null;
    }

    public void fromTag(class_2487 tag) {
        if (tag.method_10545("Waystones")) {
            Waystones.LOGGER.info("[Fabric-Waystones] Found old save data. Converting to new save format.");
            this.COMPATABILITY_ENABLED = true;
            this.parseOldTag(tag);
        } else if (tag.method_10545("waystones_compat")) {
            this.COMPATABILITY_ENABLED = true;
            this.parseCompatTag(tag);
        }
    }

    private void parseOldTag(class_2487 tag) {
        class_2499 compatTags = tag.method_10554("Waystones", 10);
        if (compatTags.isEmpty()) {
            Waystones.LOGGER.info("[Fabric-Waystones] No waystones found in old save data.");
            return;
        }
        HashSet<WaystoneBlockEntity> entities = new HashSet<WaystoneBlockEntity>();
        for (int i = 0; i < compatTags.size(); ++i) {
            int[] coords;
            WaystoneBlockEntity entity;
            Waystones.LOGGER.info("[Fabric-Waystones] Converting " + i + " of " + compatTags.size() + " waystones.");
            class_2487 waystoneTag = compatTags.method_10602(i);
            String name = waystoneTag.method_10558("Name");
            class_3218 world = this.getWorld(waystoneTag.method_10558("World"));
            if (world == null || (entity = WaystoneBlock.getEntity((class_1937)world, new class_2338((coords = waystoneTag.method_10561("Coordinates"))[0], coords[1], coords[2]))) == null) continue;
            entity.setName(name);
            String hash = entity.getHash();
            entities.add(entity);
            class_2499 players = waystoneTag.method_10554("DiscoveredBy", 10);
            for (int j = 0; j < players.size(); ++j) {
                class_2487 player = players.method_10602(j);
                String playerName = player.method_10558("PlayerName");
                if (playerName.equals("")) continue;
                if (!this.COMPATABILITY_MAP.containsKey(playerName)) {
                    this.COMPATABILITY_MAP.put(playerName, new HashSet());
                }
                this.COMPATABILITY_MAP.get(playerName).add(hash);
            }
        }
        this.STORAGE.addWaystones(entities);
    }

    private void parseCompatTag(class_2487 tag) {
        class_2499 compatTags = tag.method_10554("waystones_compat", 10);
        for (int i = 0; i < compatTags.size(); ++i) {
            String user;
            class_2487 playerTag = compatTags.method_10602(i);
            if (!playerTag.method_10545("username") || !playerTag.method_10545("waystones") || (user = playerTag.method_10558("username")).equals("")) continue;
            class_2499 knownWaystones = playerTag.method_10554("waystones", 10);
            HashSet<String> waystones = new HashSet<String>();
            for (int j = 0; j < knownWaystones.size(); ++j) {
                String hash = knownWaystones.method_10608(j);
                if (hash.equals("")) continue;
                waystones.add(hash);
            }
            this.COMPATABILITY_MAP.putIfAbsent(user, waystones);
        }
    }

    public class_2487 writeNbt(class_2487 tag) {
        if (this.COMPATABILITY_ENABLED) {
            return tag;
        }
        if (tag == null) {
            tag = new class_2487();
        }
        class_2499 compatWaystones = new class_2499();
        for (Map.Entry<String, HashSet<String>> player : this.COMPATABILITY_MAP.entrySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_10582("username", player.getKey());
            class_2499 knownWaystones = new class_2499();
            for (String hash : player.getValue()) {
                class_2487 waystone = new class_2487();
                waystone.method_10582("hash", hash);
                knownWaystones.add((Object)waystone);
            }
            playerTag.method_10566("waystones", (class_2520)knownWaystones);
            compatWaystones.add((Object)playerTag);
        }
        tag.method_10566("waystones_compat", (class_2520)compatWaystones);
        return tag;
    }

    @Nullable
    private class_3218 getWorld(String world) {
        if (this.SERVER == null) {
            return null;
        }
        for (class_3218 worlds : this.SERVER.method_3738()) {
            String id = worlds.method_27983().method_29177().toString();
            if (!id.equals(world)) continue;
            return worlds;
        }
        return null;
    }

    public void updatePlayerCompatibility(class_1657 player) {
        String username = player.method_5477().method_10851();
        if (this.COMPATABILITY_MAP.containsKey(player.method_5477().method_10851())) {
            HashSet<String> stonesToLearn = this.COMPATABILITY_MAP.get(username);
            this.COMPATABILITY_MAP.remove(username);
            ((PlayerEntityMixinAccess)player).discoverWaystones(stonesToLearn);
        }
    }
}

