/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.client;

import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

@Environment(value=EnvType.CLIENT)
public class ClientWaystoneStorage {
    private final HashMap<String, String> WAYSTONES = new HashMap();
    private final HashSet<String> GLOBALS = new HashSet();

    public void fromTag(class_2487 tag) {
        if (tag == null) {
            return;
        }
        if (tag.method_10545("waystones")) {
            this.loadWaystones(tag.method_10554("waystones", 10));
        }
        if (tag.method_10545("global_waystones")) {
            this.loadGlobals(tag.method_10554("global_waystones", 8));
        }
    }

    private void loadGlobals(class_2499 globals) {
        this.GLOBALS.clear();
        for (int i = 0; i < globals.size(); ++i) {
            this.GLOBALS.add(globals.method_10608(i));
        }
    }

    private void loadWaystones(class_2499 waystones) {
        this.WAYSTONES.clear();
        for (int i = 0; i < waystones.size(); ++i) {
            class_2487 waystoneTag = waystones.method_10602(i);
            if (!waystoneTag.method_10545("hash") || !waystoneTag.method_10545("name")) continue;
            String hash = waystoneTag.method_10558("hash");
            String name = waystoneTag.method_10558("name");
            this.WAYSTONES.put(hash, name);
        }
    }

    public String getName(String waystone) {
        return this.WAYSTONES.getOrDefault(waystone, null);
    }

    public boolean containsWaystone(String hash) {
        return this.WAYSTONES.containsKey(hash);
    }

    public HashSet<String> getGlobals() {
        return new HashSet<String>(this.GLOBALS);
    }

    public int getHashCount() {
        return this.WAYSTONES.size();
    }

    public HashSet<String> getAllHashes() {
        return new HashSet<String>(this.WAYSTONES.keySet());
    }
}

