/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.client;

import java.util.HashSet;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import wraith.waystones.Waystones;
import wraith.waystones.client.ClientWaystoneStorage;
import wraith.waystones.compat.RepurposedStructuresCompat;
import wraith.waystones.interfaces.PlayerEntityMixinAccess;
import wraith.waystones.registries.CustomBlockEntityRendererRegistry;
import wraith.waystones.registries.CustomScreenRegistry;
import wraith.waystones.registries.WaystonesModelProviderRegistry;
import wraith.waystones.screens.UniversalWaystoneScreenHandler;
import wraith.waystones.util.Config;
import wraith.waystones.util.Utils;

@Environment(value=EnvType.CLIENT)
public class WaystonesClient
implements ClientModInitializer {
    public static ClientWaystoneStorage WAYSTONE_STORAGE;

    public void onInitializeClient() {
        CustomBlockEntityRendererRegistry.RegisterBlockEntityRenderers();
        CustomScreenRegistry.registerScreens();
        WaystonesModelProviderRegistry.register();
        this.registerPacketHandlers();
        this.registerEvents();
        if (FabricLoader.getInstance().isModLoaded("repurposed_structures") && Config.getInstance().generateInVillages()) {
            RepurposedStructuresCompat.init();
        }
    }

    private void registerPacketHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("waystone_packet"), (client, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (Waystones.WAYSTONE_STORAGE != null && client.method_1576() != null) {
                client.method_1576().execute(() -> Waystones.WAYSTONE_STORAGE.fromTag(tag));
            }
            client.execute(() -> {
                WAYSTONE_STORAGE.fromTag(tag);
                if (client.field_1724 == null) {
                    return;
                }
                HashSet<String> toForget = new HashSet<String>();
                for (String hash : ((PlayerEntityMixinAccess)client.field_1724).getDiscoveredWaystones()) {
                    if (WAYSTONE_STORAGE.containsWaystone(hash)) continue;
                    toForget.add(hash);
                }
                ((PlayerEntityMixinAccess)client.field_1724).forgetWaystones(toForget);
                if (client.field_1724.field_7512 instanceof UniversalWaystoneScreenHandler) {
                    ((UniversalWaystoneScreenHandler)client.field_1724.field_7512).updateWaystones((class_1657)client.field_1724);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("waystone_config_update"), (client, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            client.execute(() -> Config.getInstance().loadConfig(tag));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("sync_player"), (client, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            client.execute(() -> {
                if (client.field_1724 != null) {
                    ((PlayerEntityMixinAccess)client.field_1724).fromTagW(tag);
                }
            });
        });
    }

    public void registerEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            WAYSTONE_STORAGE = new ClientWaystoneStorage();
        });
    }
}

