/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;
import wraith.waystones.Waystones;

public final class Config {
    private static Config instance = null;
    public class_2487 configData;
    private final Logger LOGGER = Waystones.LOGGER;
    private static final String CONFIG_FILE = "config/waystones/config.json";

    private Config() {
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public boolean generateInVillages() {
        return this.configData.method_10577("generate_in_villages");
    }

    public boolean canOwnersRedeemPayments() {
        return this.configData.method_10577("can_owners_redeem_payments");
    }

    public class_2960 teleportCostItem() {
        if ("item".equals(this.configData.method_10558("cost_type"))) {
            String[] item = this.configData.method_10558("cost_item").split(":");
            return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
        }
        return null;
    }

    public boolean storeWaystoneNbt() {
        return true;
    }

    public String teleportType() {
        return this.configData.method_10558("cost_type");
    }

    public int teleportCost() {
        return Math.abs(this.configData.method_10550("cost_amount"));
    }

    public float getHardness() {
        return this.configData.method_10583("waystone_block_hardness");
    }

    public int getMiningLevel() {
        return this.configData.method_10550("waystone_block_required_mining_level");
    }

    public boolean consumeInfiniteScroll() {
        return this.configData.method_10577("consume_infinite_knowledge_scroll_on_use");
    }

    public boolean preventNonOwnersFromBreaking() {
        return this.configData.method_10577("prevent_non_owners_from_breaking_waystone");
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        defaultConfig.method_10556("generate_in_villages", true);
        defaultConfig.method_10556("consume_infinite_knowledge_scroll_on_use", false);
        defaultConfig.method_10556("can_owners_redeem_payments", false);
        defaultConfig.method_10556("store_waystone_data_on_sneak_break", true);
        defaultConfig.method_10569("cost_amount", 1);
        defaultConfig.method_10582("cost_type", "level");
        defaultConfig.method_10582("cost_item", "minecraft:ender_pearl");
        defaultConfig.method_10548("waystone_block_hardness", 4.0f);
        defaultConfig.method_10569("waystone_block_required_mining_level", 1);
        defaultConfig.method_10556("prevent_non_owners_from_breaking_waystone", false);
        return defaultConfig;
    }

    private JsonObject toJson(class_2487 tag) {
        boolean preventNonOwnersBreaking;
        float miningLevel;
        int blockHardness;
        String costItem;
        String costType;
        int costAmount;
        boolean canOnwersRedeem;
        boolean storeWaystoneDataOnBreak;
        boolean consumeInfiniteScroll;
        boolean generateInVillages;
        boolean overwrite = false;
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        if (tag.method_10545("generate_in_villages")) {
            generateInVillages = tag.method_10577("generate_in_villages");
        } else {
            overwrite = true;
            generateInVillages = defaults.method_10577("generate_in_villages");
        }
        json.addProperty("generate_in_villages", Boolean.valueOf(generateInVillages));
        if (tag.method_10545("consume_infinite_knowledge_scroll_on_use")) {
            consumeInfiniteScroll = tag.method_10577("consume_infinite_knowledge_scroll_on_use");
        } else {
            overwrite = true;
            consumeInfiniteScroll = defaults.method_10577("consume_infinite_knowledge_scroll_on_use");
        }
        json.addProperty("consume_infinite_knowledge_scroll_on_use", Boolean.valueOf(consumeInfiniteScroll));
        if (tag.method_10545("store_waystone_data_on_sneak_break")) {
            storeWaystoneDataOnBreak = tag.method_10577("store_waystone_data_on_sneak_break");
        } else {
            overwrite = true;
            storeWaystoneDataOnBreak = defaults.method_10577("store_waystone_data_on_sneak_break");
        }
        json.addProperty("store_waystone_data_on_sneak_break", Boolean.valueOf(storeWaystoneDataOnBreak));
        if (tag.method_10545("can_owners_redeem_payments")) {
            canOnwersRedeem = tag.method_10577("can_owners_redeem_payments");
        } else {
            overwrite = true;
            canOnwersRedeem = defaults.method_10577("can_owners_redeem_payments");
        }
        json.addProperty("can_owners_redeem_payments", Boolean.valueOf(canOnwersRedeem));
        if (tag.method_10545("cost_amount")) {
            costAmount = tag.method_10550("cost_amount");
        } else {
            overwrite = true;
            costAmount = defaults.method_10550("cost_amount");
        }
        json.addProperty("cost_amount", (Number)costAmount);
        if (tag.method_10545("cost_type")) {
            costType = tag.method_10558("cost_type").toLowerCase();
        } else {
            overwrite = true;
            costType = defaults.method_10558("cost_type");
        }
        json.addProperty("cost_type", costType);
        if (tag.method_10545("cost_item")) {
            costItem = tag.method_10558("cost_item").toLowerCase();
        } else {
            overwrite = true;
            costItem = defaults.method_10558("cost_item");
        }
        json.addProperty("cost_item", costItem);
        if (tag.method_10545("waystone_block_hardness")) {
            blockHardness = tag.method_10550("waystone_block_hardness");
        } else {
            overwrite = true;
            blockHardness = defaults.method_10550("waystone_block_hardness");
        }
        json.addProperty("waystone_block_hardness", (Number)blockHardness);
        if (tag.method_10545("waystone_block_required_mining_level")) {
            miningLevel = tag.method_10583("waystone_block_required_mining_level");
        } else {
            overwrite = true;
            miningLevel = defaults.method_10583("waystone_block_required_mining_level");
        }
        json.addProperty("waystone_block_required_mining_level", (Number)Float.valueOf(miningLevel));
        if (tag.method_10545("prevent_non_owners_from_breaking_waystone")) {
            preventNonOwnersBreaking = tag.method_10577("prevent_non_owners_from_breaking_waystone");
        } else {
            overwrite = true;
            preventNonOwnersBreaking = defaults.method_10577("prevent_non_owners_from_breaking_waystone");
        }
        json.addProperty("prevent_non_owners_from_breaking_waystone", Boolean.valueOf(preventNonOwnersBreaking));
        this.createFile(json, overwrite);
        return json;
    }

    private class_2487 toNbtCompound(JsonObject json) {
        boolean preventNonOwnersBreaking;
        float miningLevel;
        int blockHardness;
        String costType;
        String costItem;
        int costAmount;
        boolean canOnwersRedeem;
        boolean storeWaystoneDataOnBreak;
        boolean consumeInfiniteScroll;
        boolean generateInVillages;
        boolean overwrite = false;
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        if (json.has("generate_in_villages")) {
            generateInVillages = json.get("generate_in_villages").getAsBoolean();
        } else {
            overwrite = true;
            generateInVillages = defaults.method_10577("generate_in_villages");
        }
        tag.method_10556("generate_in_villages", generateInVillages);
        if (json.has("consume_infinite_knowledge_scroll_on_use")) {
            consumeInfiniteScroll = json.get("consume_infinite_knowledge_scroll_on_use").getAsBoolean();
        } else {
            overwrite = true;
            consumeInfiniteScroll = defaults.method_10577("consume_infinite_knowledge_scroll_on_use");
        }
        tag.method_10556("consume_infinite_knowledge_scroll_on_use", consumeInfiniteScroll);
        if (json.has("store_waystone_data_on_sneak_break")) {
            storeWaystoneDataOnBreak = json.get("store_waystone_data_on_sneak_break").getAsBoolean();
        } else {
            overwrite = true;
            storeWaystoneDataOnBreak = defaults.method_10577("store_waystone_data_on_sneak_break");
        }
        tag.method_10556("store_waystone_data_on_sneak_break", storeWaystoneDataOnBreak);
        if (json.has("can_owners_redeem_payments")) {
            canOnwersRedeem = json.get("can_owners_redeem_payments").getAsBoolean();
        } else {
            overwrite = true;
            canOnwersRedeem = defaults.method_10577("can_owners_redeem_payments");
        }
        tag.method_10556("can_owners_redeem_payments", canOnwersRedeem);
        if (json.has("cost_amount")) {
            costAmount = json.get("cost_amount").getAsInt();
        } else {
            overwrite = true;
            costAmount = defaults.method_10550("cost_amount");
        }
        tag.method_10569("cost_amount", costAmount);
        if (json.has("cost_item")) {
            costItem = json.get("cost_item").getAsString();
        } else {
            overwrite = true;
            costItem = defaults.method_10558("cost_item");
        }
        tag.method_10582("cost_item", costItem);
        if (json.has("cost_type")) {
            costType = json.get("cost_type").getAsString();
        } else {
            overwrite = true;
            costType = defaults.method_10558("cost_type");
        }
        tag.method_10582("cost_type", costType);
        if (json.has("waystone_block_hardness")) {
            blockHardness = json.get("waystone_block_hardness").getAsInt();
        } else {
            overwrite = true;
            blockHardness = defaults.method_10550("waystone_block_hardness");
        }
        tag.method_10569("waystone_block_hardness", blockHardness);
        if (json.has("waystone_block_required_mining_level")) {
            miningLevel = json.get("waystone_block_required_mining_level").getAsFloat();
        } else {
            overwrite = true;
            miningLevel = defaults.method_10583("waystone_block_required_mining_level");
        }
        tag.method_10548("waystone_block_required_mining_level", miningLevel);
        if (json.has("prevent_non_owners_from_breaking_waystone")) {
            preventNonOwnersBreaking = json.get("prevent_non_owners_from_breaking_waystone").getAsBoolean();
        } else {
            overwrite = true;
            preventNonOwnersBreaking = defaults.method_10577("prevent_non_owners_from_breaking_waystone");
        }
        tag.method_10556("prevent_non_owners_from_breaking_waystone", preventNonOwnersBreaking);
        this.createFile(this.toJson(tag), overwrite);
        return tag;
    }

    public boolean loadConfig() {
        try {
            return this.loadConfig(Config.getJsonObject(Config.readFile(new File(CONFIG_FILE))));
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            this.configData = this.toNbtCompound(fileConfig);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.configData = config;
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = new JsonParser().parse(gson.toJson((JsonElement)contents)).getAsJsonObject();
        File file = new File(CONFIG_FILE);
        if (file.exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        file.setExecutable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            writer.write(gson.toJson((JsonElement)new JsonParser().parse(json).getAsJsonObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class_2487 toNbtCompound() {
        return this.configData;
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        String result = scanner.next();
        scanner.close();
        return result;
    }

    public static JsonObject getJsonObject(String json) {
        return new JsonParser().parse(json).getAsJsonObject();
    }

    public void print(class_3222 player) {
        for (Map.Entry config : this.toJson(this.configData).entrySet()) {
            if (((JsonElement)config.getValue()).isJsonObject()) continue;
            player.method_7353((class_2561)new class_2585("\u00a76[\u00a7e" + (String)config.getKey() + "\u00a76] \u00a73 " + config.getValue()), false);
        }
    }
}

