/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import wraith.waystones.Waystones;
import wraith.waystones.block.WaystoneBlock;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.interfaces.PlayerEntityMixinAccess;
import wraith.waystones.util.Utils;

public final class WaystonePacketHandler {
    private WaystonePacketHandler() {
    }

    public static void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("remove_waystone_owner"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> {
                if (tag == null || !tag.method_10545("waystone_hash") || !tag.method_10545("waystone_owner")) {
                    return;
                }
                String hash = tag.method_10558("waystone_hash");
                UUID owner = tag.method_25926("waystone_owner");
                if (player.method_5667().equals(owner) || player.method_5687(2)) {
                    Waystones.WAYSTONE_STORAGE.setOwner(hash, null);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("waystone_gui_slot_click"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> {
                if (tag == null || !tag.method_10545("sync_id") || !tag.method_10545("clicked_slot")) {
                    return;
                }
                int syncId = tag.method_10550("sync_id");
                int button = tag.method_10550("clicked_slot");
                if (player.field_7512.field_7763 == syncId) {
                    player.field_7512.method_7604((class_1657)player, button);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("rename_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (!(tag != null && tag.method_10545("waystone_name") && tag.method_10545("waystone_hash") && tag.method_10545("waystone_owner"))) {
                return;
            }
            String name = tag.method_10558("waystone_name");
            String hash = tag.method_10558("waystone_hash");
            UUID owner = tag.method_25926("waystone_owner");
            server.execute(() -> {
                if (Waystones.WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && owner.equals(Waystones.WAYSTONE_STORAGE.getWaystone(hash).getOwner()) || player.method_5687(2))) {
                    Waystones.WAYSTONE_STORAGE.renameWaystone(hash, name);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("forget_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash")) {
                return;
            }
            String hash = tag.method_10558("waystone_hash");
            server.execute(() -> {
                WaystoneBlockEntity waystone = Waystones.WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null || waystone.isGlobal()) {
                    return;
                }
                if (player.method_5667().equals(waystone.getOwner())) {
                    waystone.setOwner(null);
                }
                ((PlayerEntityMixinAccess)player).forgetWaystone(hash);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("request_player_waystone_update"), (server, player, networkHandler, data, sender) -> server.execute(((PlayerEntityMixinAccess)player)::syncData));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("toggle_global_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash") || !tag.method_10545("waystone_owner")) {
                return;
            }
            server.execute(() -> {
                String hash = tag.method_10558("waystone_hash");
                UUID owner = tag.method_25926("waystone_owner");
                if (Waystones.WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && owner.equals(Waystones.WAYSTONE_STORAGE.getWaystone(hash).getOwner()) || player.method_5687(2))) {
                    Waystones.WAYSTONE_STORAGE.toggleGlobal(hash);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("sync_player_from_client"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> ((PlayerEntityMixinAccess)player).fromTagW(tag));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("teleport_to_waystone"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash")) {
                return;
            }
            server.execute(() -> {
                if (!tag.method_10545("waystone_hash")) {
                    return;
                }
                String hash = tag.method_10558("waystone_hash");
                boolean isAbyssWatcher = tag.method_10545("from_abyss_watcher") && tag.method_10577("from_abyss_watcher");
                WaystoneBlockEntity waystone = Waystones.WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null) {
                    return;
                }
                if (waystone.method_10997() != null && !(waystone.method_10997().method_8320(waystone.method_11016()).method_26204() instanceof WaystoneBlock)) {
                    Waystones.WAYSTONE_STORAGE.removeWaystone(hash);
                    waystone.method_10997().method_8544(waystone.method_11016());
                } else if (Utils.canTeleport((class_1657)player, hash)) {
                    class_2338 waystonePos;
                    class_2338 playerPos = player.method_24515();
                    waystone.teleportPlayer((class_1657)player, isAbyssWatcher);
                    player.field_6002.method_8396((class_1657)player, playerPos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
                    if (isAbyssWatcher) {
                        player.field_6002.method_8396((class_1657)player, playerPos, class_3417.field_15210, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    if (!(waystonePos = waystone.method_11016()).method_19771((class_2382)playerPos, 6.0)) {
                        player.field_6002.method_8396((class_1657)player, waystonePos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            });
        });
    }
}

