/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import wraith.waystones.block.WaystoneBlock;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.interfaces.PlayerEntityMixinAccess;
import wraith.waystones.interfaces.WaystoneValue;
import wraith.waystones.mixin.MinecraftServerAccessor;
import wraith.waystones.util.CompatibilityLayer;
import wraith.waystones.util.Utils;

public class WaystoneStorage {
    private final class_18 state;
    private final ConcurrentHashMap<String, WaystoneValue> WAYSTONES = new ConcurrentHashMap();
    private final MinecraftServer server;
    private static final String ID = "fw_waystones";
    private final CompatibilityLayer compat;

    public WaystoneStorage(MinecraftServer server) {
        CompatibilityLayer compatLoading = new CompatibilityLayer(this, server);
        this.server = server;
        File worldDirectory = ((MinecraftServerAccessor)server).getSession().method_27424(server.method_30002().method_27983());
        File file = new File(worldDirectory, "data/waystones:waystones.dat");
        if (file.exists()) {
            file.renameTo(new File(worldDirectory, "data/fw_waystones.dat"));
        }
        class_18 pState = new class_18(){

            public class_2487 method_75(class_2487 tag) {
                return WaystoneStorage.this.toTag(tag);
            }
        };
        this.state = this.server.method_3847(class_3218.field_25179).method_17983().method_17924(arg_0 -> this.lambda$new$0(pState, arg_0), () -> WaystoneStorage.lambda$new$1(pState), ID);
        if (!compatLoading.loadCompatibility()) {
            compatLoading = null;
        }
        this.compat = compatLoading;
        this.loadOrSaveWaystones(false);
    }

    public void fromTag(class_2487 tag) {
        if (this.server == null || tag == null || !tag.method_10545("waystones")) {
            return;
        }
        this.WAYSTONES.clear();
        HashSet<String> globals = new HashSet<String>();
        for (class_2520 element : tag.method_10554("global_waystones", 8)) {
            globals.add(element.method_10714());
        }
        class_2499 waystones = tag.method_10554("waystones", 10);
        for (int i = 0; i < waystones.size(); ++i) {
            class_2487 waystoneTag = waystones.method_10602(i);
            if (!waystoneTag.method_10545("hash") || !waystoneTag.method_10545("dimension") || !waystoneTag.method_10545("position")) continue;
            String name = waystoneTag.method_10558("name");
            String hash = waystoneTag.method_10558("hash");
            String dimension = waystoneTag.method_10558("dimension");
            int[] coordinates = waystoneTag.method_10561("position");
            class_2338 pos = new class_2338(coordinates[0], coordinates[1], coordinates[2]);
            this.WAYSTONES.put(hash, new Lazy(name, pos, hash, dimension, globals.contains(hash)));
        }
    }

    public class_2487 toTag(class_2487 tag) {
        if (tag == null) {
            tag = new class_2487();
        }
        class_2499 waystones = new class_2499();
        for (Map.Entry<String, WaystoneValue> waystone : this.WAYSTONES.entrySet()) {
            String hash = waystone.getKey();
            WaystoneValue entity = waystone.getValue();
            class_2487 waystoneTag = new class_2487();
            waystoneTag.method_10582("hash", hash);
            waystoneTag.method_10582("name", entity.getWaystoneName());
            class_2338 pos = entity.way_getPos();
            waystoneTag.method_10572("position", Arrays.asList(pos.method_10263(), pos.method_10264(), pos.method_10260()));
            waystoneTag.method_10582("dimension", entity.getWorldName());
            waystones.add((Object)waystoneTag);
        }
        tag.method_10566("waystones", (class_2520)waystones);
        class_2499 globals = new class_2499();
        ArrayList<String> globalWaystones = this.getGlobals();
        for (String globalWaystone : globalWaystones) {
            globals.add((Object)class_2519.method_23256((String)globalWaystone));
        }
        tag.method_10566("global_waystones", (class_2520)globals);
        return tag;
    }

    public boolean hasWaystone(WaystoneBlockEntity waystone) {
        return this.WAYSTONES.containsValue(waystone);
    }

    public void addWaystone(WaystoneBlockEntity waystone) {
        this.WAYSTONES.put(waystone.getHash(), waystone);
        this.loadOrSaveWaystones(true);
    }

    public void addWaystones(HashSet<WaystoneBlockEntity> waystones) {
        for (WaystoneBlockEntity waystone : waystones) {
            this.WAYSTONES.put(waystone.getHash(), waystone);
        }
        this.loadOrSaveWaystones(true);
    }

    public void loadOrSaveWaystones(boolean save) {
        if (this.server == null) {
            return;
        }
        class_3218 world = this.server.method_3847(class_3218.field_25179);
        if (save) {
            this.state.method_80();
            this.sendToAllPlayers();
        } else {
            try {
                class_2487 compoundTag = world.method_17983().method_17923(ID, class_155.method_16673().getWorldVersion());
                this.state.method_75(compoundTag.method_10562("data"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        world.method_17983().method_125();
    }

    public void sendToAllPlayers() {
        if (this.server == null) {
            return;
        }
        for (class_3222 player : this.server.method_3760().method_14571()) {
            this.sendToPlayer(player);
        }
    }

    public void sendToPlayer(class_3222 player) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_10794(this.toTag(new class_2487()));
        ServerPlayNetworking.send((class_3222)player, (class_2960)Utils.ID("waystone_packet"), (class_2540)data);
    }

    public void removeWaystone(String hash) {
        this.WAYSTONES.remove(hash);
        this.forgetForAllPlayers(hash);
        this.loadOrSaveWaystones(true);
    }

    private void forgetForAllPlayers(String hash) {
        for (class_3222 player : this.server.method_3760().method_14571()) {
            ((PlayerEntityMixinAccess)player).forgetWaystone(hash);
        }
    }

    public void removeWaystone(WaystoneBlockEntity waystone) {
        String hash = waystone.getHash();
        this.WAYSTONES.remove(hash);
        this.forgetForAllPlayers(hash);
        this.loadOrSaveWaystones(true);
    }

    public void renameWaystone(WaystoneBlockEntity waystone, String name) {
        waystone.setName(name);
        this.loadOrSaveWaystones(true);
    }

    public void renameWaystone(String hash, String name) {
        if (this.WAYSTONES.containsKey(hash)) {
            this.WAYSTONES.get(hash).getEntity().setName(name);
            this.loadOrSaveWaystones(true);
        }
    }

    public WaystoneBlockEntity getWaystone(String hash) {
        WaystoneValue value = this.WAYSTONES.getOrDefault(hash, null);
        return value != null ? value.getEntity() : null;
    }

    public boolean containsHash(String hash) {
        return this.WAYSTONES.containsKey(hash);
    }

    public ArrayList<String> getGlobals() {
        ArrayList<String> globals = new ArrayList<String>();
        for (Map.Entry<String, WaystoneValue> waystone : this.WAYSTONES.entrySet()) {
            if (!waystone.getValue().isGlobal()) continue;
            globals.add(waystone.getKey());
        }
        return globals;
    }

    public void toggleGlobal(String hash) {
        WaystoneBlockEntity waystone = this.getWaystone(hash);
        if (waystone == null) {
            return;
        }
        waystone.toggleGlobal();
        this.sendToAllPlayers();
    }

    public void setOwner(String hash, class_1657 owner) {
        if (this.WAYSTONES.containsKey(hash)) {
            this.WAYSTONES.get(hash).getEntity().setOwner(owner);
        }
    }

    public HashSet<String> getAllHashes() {
        return new HashSet<String>(this.WAYSTONES.keySet());
    }

    public int getCount() {
        return this.WAYSTONES.size();
    }

    public void sendCompatData(class_3222 player) {
        if (this.compat != null) {
            this.compat.updatePlayerCompatibility((class_1657)player);
        }
    }

    private static /* synthetic */ 1 lambda$new$1(1 pState) {
        return pState;
    }

    private /* synthetic */ 1 lambda$new$0(1 pState, class_2487 nbtCompound) {
        this.fromTag(nbtCompound);
        return pState;
    }

    final class Lazy
    implements WaystoneValue {
        final String name;
        final class_2338 pos;
        final String hash;
        final String dimension;
        final boolean isGlobal;
        WaystoneBlockEntity entity;
        class_1937 world;

        Lazy(String name, class_2338 pos, String hash, String dimension, boolean global) {
            this.name = name;
            this.pos = pos;
            this.hash = hash;
            this.dimension = dimension;
            this.isGlobal = global;
        }

        @Override
        public WaystoneBlockEntity getEntity() {
            if (this.entity == null) {
                for (class_3218 world : WaystoneStorage.this.server.method_3738()) {
                    if (!WaystoneBlock.getDimensionName((class_1937)world).equals(this.dimension)) continue;
                    WaystoneBlockEntity entity = WaystoneBlock.getEntity((class_1937)world, this.pos);
                    if (entity == null) break;
                    WaystoneStorage.this.WAYSTONES.put(this.hash, entity);
                    this.entity = entity;
                    this.world = world;
                    break;
                }
            }
            return this.entity;
        }

        @Override
        public String getWaystoneName() {
            return this.name;
        }

        @Override
        public class_2338 way_getPos() {
            return this.pos;
        }

        @Override
        public String getWorldName() {
            return this.dimension;
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }
    }
}

