/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import wraith.waystones.Waystones;
import wraith.waystones.compat.RepurposedStructuresCompat;
import wraith.waystones.interfaces.PlayerEntityMixinAccess;
import wraith.waystones.util.Config;
import wraith.waystones.util.Utils;
import wraith.waystones.util.WaystoneStorage;
import wraith.waystones.util.WaystonesWorldgen;

public class WaystonesEventManager {
    private WaystonesEventManager() {
    }

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Waystones.WAYSTONE_STORAGE = new WaystoneStorage(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            Waystones.WAYSTONE_STORAGE.loadOrSaveWaystones(true);
            Waystones.WAYSTONE_STORAGE = null;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_2540 data = new class_2540(Unpooled.buffer());
            data.method_10794(Config.getInstance().toNbtCompound());
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)Utils.ID("waystone_config_update"), (class_2540)data);
            Waystones.WAYSTONE_STORAGE.sendToPlayer(handler.field_14140);
            Waystones.WAYSTONE_STORAGE.sendCompatData(handler.field_14140);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            WaystonesWorldgen.registerVanillaVillageWorldgen(server);
            if (FabricLoader.getInstance().isModLoaded("repurposed_structures")) {
                RepurposedStructuresCompat.registerRSVillages(server);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> ((PlayerEntityMixinAccess)newPlayer).syncData());
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waystones").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(1))).executes(context -> {
            Config.getInstance().loadConfig();
            class_2540 data = new class_2540(Unpooled.buffer());
            data.method_10794(Config.getInstance().toNbtCompound());
            for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)Utils.ID("waystone_config_update"), (class_2540)data);
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player != null) {
                player.method_7353((class_2561)new class_2585("\u00a76[\u00a7eWaystones\u00a76] \u00a73has successfully reloaded!"), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"display").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            Config.getInstance().print(player);
            return 1;
        }))));
    }
}

