/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Block.Radio.Tower;

import com.Maxwell.cyber_ware_port.Common.Block.Radio.Tower.RadioTowerCoreBlock;
import com.Maxwell.cyber_ware_port.Common.Block.Radio.Tower.RadioTowerFenceBlock;
import com.Maxwell.cyber_ware_port.Init.ModBlockEntities;
import com.Maxwell.cyber_ware_port.Init.ModBlocks;
import com.Maxwell.cyber_ware_port.Init.ModEntities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RadioTowerCoreBlockEntity
extends BlockEntity {
    private static final int SPAWN_COOLDOWN = 300;
    private int tickCounter = 0;
    private static final int BASE_HEIGHT = 4;
    private static final int SHAFT_HEIGHT = 6;
    private static final int TOTAL_HEIGHT = 10;

    public RadioTowerCoreBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.RADIO_TOWER_CORE.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("TickCounter", this.tickCounter);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.tickCounter = pTag.m_128451_("TickCounter");
    }

    public void deformFencesOnly() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.setStructureState(false, false);
    }

    public void tryToFormStructure() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (this.checkStructure()) {
            this.setStructureState(true);
        }
    }

    public void deformStructure() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.setStructureState(false);
    }

    private void setStructureState(boolean formed) {
        this.setStructureState(formed, true);
    }

    private void setStructureState(boolean formed, boolean includeCore) {
        int yOffset;
        BlockState coreState;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos corePos = this.m_58899_();
        if (includeCore && (coreState = this.m_58900_()).m_61138_((Property)RadioTowerCoreBlock.FORMED)) {
            level.m_7731_(corePos, (BlockState)coreState.m_61124_((Property)RadioTowerCoreBlock.FORMED, (Comparable)Boolean.valueOf(formed)), 3);
        }
        for (yOffset = 1; yOffset <= 6; ++yOffset) {
            this.updateFenceState(level, corePos.m_6625_(yOffset), formed);
        }
        for (yOffset = 7; yOffset <= 10; ++yOffset) {
            BlockPos layerCenter = corePos.m_6625_(yOffset);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.updateFenceState(level, layerCenter.m_7918_(x, 0, z), formed);
                }
            }
        }
    }

    private void updateFenceState(Level level, BlockPos pos, boolean formed) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get()) && state.m_61138_((Property)RadioTowerFenceBlock.FORMED) && (Boolean)state.m_61143_((Property)RadioTowerFenceBlock.FORMED) != formed) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)RadioTowerFenceBlock.FORMED, (Comparable)Boolean.valueOf(formed)), 3);
        }
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, RadioTowerCoreBlockEntity pBlockEntity) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (pBlockEntity.tickCounter == 0) {
            // empty if block
        }
        if (!((Boolean)pState.m_61143_((Property)RadioTowerCoreBlock.FORMED)).booleanValue()) {
            return;
        }
        ++pBlockEntity.tickCounter;
        if (pBlockEntity.tickCounter >= 300) {
            pBlockEntity.tickCounter = 0;
            pBlockEntity.spawnMobsAroundTower((ServerLevel)pLevel, pPos, pLevel.m_213780_());
        }
    }

    private void spawnMobsAroundTower(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Player player = pLevel.m_45924_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 80.0, true);
        if (player == null) {
            return;
        }
        int spawnCount = 2 + pRandom.m_188503_(3);
        for (int i = 0; i < spawnCount; ++i) {
            this.spawnOneCyberMob(pLevel, pPos, pRandom);
        }
    }

    private void spawnOneCyberMob(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        ArrayList<EntityType> spawnList = new ArrayList<EntityType>();
        if (pLevel.m_46472_() == Level.f_46429_) {
            spawnList.add((EntityType)ModEntities.CYBER_WITHER_SKELETON.get());
        } else {
            spawnList.add((EntityType)ModEntities.CYBER_ZOMBIE.get());
            spawnList.add((EntityType)ModEntities.CYBER_SKELETON.get());
            spawnList.add((EntityType)ModEntities.CYBER_CREEPER.get());
        }
        EntityType mobToSpawn = (EntityType)spawnList.get(pRandom.m_188503_(spawnList.size()));
        BlockPos groundLevelPos = pPos.m_6625_(10);
        for (int i = 0; i < 15; ++i) {
            Monster monster;
            int minDistance = 16;
            int maxDistance = 32;
            float angle = pRandom.m_188501_() * 2.0f * (float)Math.PI;
            int distance = minDistance + pRandom.m_188503_(maxDistance - minDistance);
            int x = groundLevelPos.m_123341_() + (int)(Math.cos(angle) * (double)distance);
            int z = groundLevelPos.m_123343_() + (int)(Math.sin(angle) * (double)distance);
            BlockPos potentialPos = new BlockPos(x, groundLevelPos.m_123342_(), z);
            BlockPos spawnPos = this.findValidSpawnPos((Level)pLevel, potentialPos);
            if (spawnPos == null || (monster = (Monster)mobToSpawn.m_20615_((Level)pLevel)) == null) continue;
            monster.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, pRandom.m_188501_() * 360.0f, 0.0f);
            monster.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(spawnPos), MobSpawnType.EVENT, null, null);
            pLevel.m_7967_((Entity)monster);
            pLevel.m_5594_(null, pPos, SoundEvents.f_11822_, SoundSource.BLOCKS, 1.0f, 1.5f);
            return;
        }
    }

    @Nullable
    private BlockPos findValidSpawnPos(Level pLevel, BlockPos pPos) {
        for (int yOffset = -10; yOffset <= 5; ++yOffset) {
            BlockPos currentPos = pPos.m_6630_(yOffset);
            if (!this.isValidSpawnLocation(pLevel, currentPos)) continue;
            return currentPos;
        }
        return null;
    }

    private boolean isValidSpawnLocation(Level level, BlockPos pos) {
        BlockState groundState = level.m_8055_(pos.m_7495_());
        BlockState mainState = level.m_8055_(pos);
        BlockState headState = level.m_8055_(pos.m_7494_());
        return groundState.m_60804_((BlockGetter)level, pos.m_7495_()) && !mainState.m_60838_((BlockGetter)level, pos) && !headState.m_60838_((BlockGetter)level, pos);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB((double)pos.m_123341_() - 5.0, (double)pos.m_123342_() - 15.0, (double)pos.m_123343_() - 5.0, (double)pos.m_123341_() + 6.0, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 6.0);
    }

    private boolean checkStructure() {
        int z;
        int x;
        BlockPos layerCenter;
        int yOffset;
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        BlockPos corePos = this.m_58899_();
        for (yOffset = 1; yOffset <= 6; ++yOffset) {
            layerCenter = corePos.m_6625_(yOffset);
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockPos targetPos = layerCenter.m_7918_(x, 0, z);
                    BlockState state = level.m_8055_(targetPos);
                    if (!(x == 0 && z == 0 ? !state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get()) : !state.m_60795_())) continue;
                    return false;
                }
            }
        }
        for (yOffset = 7; yOffset <= 10; ++yOffset) {
            layerCenter = corePos.m_6625_(yOffset);
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockState state = level.m_8055_(layerCenter.m_7918_(x, 0, z));
                    if (state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

