/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Capability;

import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.RobosurgeonBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Item.Base.BodyPartType;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Common.Network.A_PacketHandler;
import com.Maxwell.cyber_ware_port.Common.Network.SyncCyberwareDataPacket;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class CyberwareUserData
implements INBTSerializable<CompoundTag>,
IEnergyStorage {
    private boolean hasCyberLeftArm = false;
    private boolean hasCyberRightArm = false;
    private boolean hasCyberLeftLeg = false;
    private boolean hasCyberRightLeg = false;
    private boolean isInitialized = false;
    private int maxTolerance = 100;
    private int currentEnergy = 0;
    private final ItemStackHandler installedCyberware = new ItemStackHandler(RobosurgeonBlockEntity.TOTAL_SLOTS){

        protected void onContentsChanged(int slot) {
            CyberwareUserData.this.updateLimbStatus();
        }
    };
    private int maxEnergy = 0;
    private int respawnGracePeriod = 0;
    private int lastProduction = 0;
    private int lastConsumption = 0;
    private int toleranceImmunityTime = 0;

    public void recalculateCapacity(ServerPlayer player) {
        ItemStack stack;
        int slotIndex;
        int i;
        float oldMaxHealth = player.m_21233_();
        float oldHealth = player.m_21223_();
        float healthRatio = oldMaxHealth > 0.0f ? oldHealth / oldMaxHealth : 1.0f;
        int totalCapacity = 0;
        AttributeMap attributeMap = player.m_21204_();
        for (i = 0; i < this.installedCyberware.getSlots(); ++i) {
            Item item;
            slotIndex = i;
            stack = this.installedCyberware.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cw = (ICyberware)item;
            cw.getAttributeModifiers(stack).forEach((attribute, modifier) -> {
                AttributeInstance instance = attributeMap.m_22146_(attribute);
                if (instance != null) {
                    UUID slotUUID = this.generateUUID(slotIndex, modifier.m_22209_());
                    instance.m_22120_(slotUUID);
                }
            });
        }
        for (i = 0; i < this.installedCyberware.getSlots(); ++i) {
            Item item;
            slotIndex = i;
            stack = this.installedCyberware.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cyberware = (ICyberware)item;
            int count = stack.m_41613_();
            if (cyberware.hasEnergyProperties(stack)) {
                int singleStorage = cyberware.getEnergyStorage(stack);
                totalCapacity += singleStorage * count;
            }
            if (!cyberware.isActive(stack)) continue;
            cyberware.getAttributeModifiers(stack).forEach((attribute, originalModifier) -> {
                AttributeInstance instance;
                if (attributeMap.m_22171_(attribute) && (instance = attributeMap.m_22146_(attribute)) != null) {
                    UUID slotUUID = this.generateUUID(slotIndex, originalModifier.m_22209_());
                    double value = originalModifier.m_22218_() * (double)count;
                    AttributeModifier newModifier = new AttributeModifier(slotUUID, "Cyberware Slot " + slotIndex, value, originalModifier.m_22217_());
                    if (!instance.m_22109_(newModifier)) {
                        instance.m_22118_(newModifier);
                    }
                }
            });
        }
        this.maxEnergy = totalCapacity;
        if (this.currentEnergy > this.maxEnergy) {
            this.currentEnergy = this.maxEnergy;
        }
        float newMaxHealth = player.m_21233_();
        if (healthRatio > 1.0f) {
            healthRatio = 1.0f;
        }
        player.m_21153_(newMaxHealth * healthRatio);
    }

    public void setRespawnGracePeriod(int ticks) {
        this.respawnGracePeriod = ticks;
    }

    private void updateLimbStatus() {
        this.hasCyberLeftArm = false;
        this.hasCyberRightArm = false;
        this.hasCyberLeftLeg = false;
        this.hasCyberRightLeg = false;
        for (int i = 0; i < this.installedCyberware.getSlots(); ++i) {
            ItemStack stack = this.installedCyberware.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ICyberware) || this.isHumanPart(stack)) continue;
            if (i == RobosurgeonBlockEntity.SLOT_ARMS) {
                this.hasCyberLeftArm = true;
                continue;
            }
            if (i == RobosurgeonBlockEntity.SLOT_ARMS + 1) {
                this.hasCyberRightArm = true;
                continue;
            }
            if (i == RobosurgeonBlockEntity.SLOT_LEGS) {
                this.hasCyberLeftLeg = true;
                continue;
            }
            if (i != RobosurgeonBlockEntity.SLOT_LEGS + 1) continue;
            this.hasCyberRightLeg = true;
        }
    }

    private boolean isHumanPart(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == ModItems.HUMAN_LEFT_ARM.get() || item == ModItems.HUMAN_RIGHT_ARM.get() || item == ModItems.HUMAN_LEFT_LEG.get() || item == ModItems.HUMAN_RIGHT_LEG.get();
    }

    public boolean hasCyberLeftArm() {
        return this.hasCyberLeftArm;
    }

    public boolean hasCyberRightArm() {
        return this.hasCyberRightArm;
    }

    public boolean hasCyberLeftLeg() {
        return this.hasCyberLeftLeg;
    }

    public boolean hasCyberRightLeg() {
        return this.hasCyberRightLeg;
    }

    private UUID generateUUID(int slot, UUID originalId) {
        return UUID.nameUUIDFromBytes((originalId.toString() + "_" + slot).getBytes());
    }

    public void tick(ServerPlayer player) {
        if (this.toleranceImmunityTime > 0) {
            --this.toleranceImmunityTime;
        }
        if (this.respawnGracePeriod > 0) {
            --this.respawnGracePeriod;
        }
        this.checkBodyCondition(player);
        if (this.maxEnergy <= 0) {
            this.lastProduction = 0;
            this.lastConsumption = 0;
            return;
        }
        int totalProduction = 0;
        int totalConsumption = 0;
        for (int i = 0; i < this.installedCyberware.getSlots(); ++i) {
            ICyberware cyberware;
            Item item;
            ItemStack stack = this.installedCyberware.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware) || !(cyberware = (ICyberware)item).hasEnergyProperties(stack)) continue;
            int count = stack.m_41613_();
            ICyberware.StackingRule rule = cyberware.getStackingEnergyRule(stack);
            totalProduction += rule.calculate(cyberware.getEnergyGeneration(stack), count);
            totalConsumption += rule.calculate(cyberware.getEnergyConsumption(stack), count);
        }
        this.lastProduction = totalProduction;
        this.lastConsumption = totalConsumption;
        if (totalProduction > 0) {
            this.receiveEnergy(totalProduction, false);
        }
        boolean hasSufficientPower = true;
        if (totalConsumption > 0) {
            if (this.currentEnergy >= totalConsumption) {
                this.extractEnergy(totalConsumption, false);
            } else {
                hasSufficientPower = false;
                this.currentEnergy = 0;
            }
        }
        if (player.f_19797_ % 20 == 0) {
            this.syncToClient(player);
        }
    }

    public void setInitialized() {
        this.isInitialized = true;
    }

    private void checkBodyCondition(ServerPlayer player) {
        int air;
        EnumSet<BodyPartType> presentParts = EnumSet.noneOf(BodyPartType.class);
        ItemStackHandler handler = this.installedCyberware;
        boolean hasRightLeg = !handler.getStackInSlot(RobosurgeonBlockEntity.SLOT_LEGS).m_41619_();
        boolean hasLeftLeg = !handler.getStackInSlot(RobosurgeonBlockEntity.SLOT_LEGS + 1).m_41619_();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ICyberware cyberware;
            BodyPartType type;
            Item item;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware) || (type = (cyberware = (ICyberware)item).getBodyPartType(stack)) == BodyPartType.NONE) continue;
            presentParts.add(type);
        }
        if (!presentParts.contains((Object)BodyPartType.BRAIN)) {
            this.killPlayer(player, "cyberware.brainless");
            return;
        }
        if (!presentParts.contains((Object)BodyPartType.HEART)) {
            this.killPlayer(player, "cyberware.heartless");
            return;
        }
        if (!presentParts.contains((Object)BodyPartType.MUSCLE)) {
            this.killPlayer(player, "cyberware.nomuscles");
            return;
        }
        if (!presentParts.contains((Object)BodyPartType.BONES)) {
            this.killPlayer(player, "cyberware.cyberware_missing_bone");
            return;
        }
        if (!presentParts.contains((Object)BodyPartType.EYES)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false));
        }
        if (!presentParts.contains((Object)BodyPartType.LUNGS) && (air = player.m_20146_()) > -20) {
            player.m_20301_(air - 1);
            if (air <= 0 && player.f_19797_ % 20 == 0) {
                player.m_6469_(player.m_269291_().m_269063_(), 2.0f);
            }
        }
        if (!presentParts.contains((Object)BodyPartType.STOMACH)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 1, false, false));
        }
        if (!hasRightLeg && !hasLeftLeg) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 6, false, false));
        } else if (!hasRightLeg || !hasLeftLeg) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2, false, false));
        }
        if (this.getTolerance() <= 0) {
            if (this.respawnGracePeriod <= 0) {
                this.killPlayer(player, "cyberware.noessence");
            } else if (player.f_19797_ % 400 == 0) {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                player.m_213846_((Component)Component.m_237115_((String)"cyberware.message.critical_condition").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        if (this.toleranceImmunityTime > 0) {
            return;
        }
        int rejectionThreshold = (int)((float)this.maxTolerance * 0.25f);
        int currentTolerance = this.getTolerance();
        if (currentTolerance < rejectionThreshold) {
            if (player.f_19797_ % 100 == 0) {
                player.m_21153_(player.m_21223_() - 2.0f);
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 60, 1, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 1, false, false));
            if (player.m_217043_().m_188501_() < 0.01f && !player.m_21205_().m_41619_()) {
                player.m_36176_(player.m_21205_(), true);
            }
        }
    }

    public void applyImmunity(int ticks) {
        this.toleranceImmunityTime = Math.max(this.toleranceImmunityTime, ticks);
    }

    private void killPlayer(ServerPlayer player, final String suffix) {
        DamageSource source = new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_)){

            public Component m_6157_(LivingEntity entity) {
                return Component.m_237110_((String)("death.attack." + suffix), (Object[])new Object[]{entity.m_5446_()});
            }
        };
        player.m_6469_(source, Float.MAX_VALUE);
    }

    public void copyFrom(CyberwareUserData other) {
        for (int i = 0; i < this.installedCyberware.getSlots(); ++i) {
            this.installedCyberware.setStackInSlot(i, other.installedCyberware.getStackInSlot(i).m_41777_());
        }
        this.maxTolerance = other.maxTolerance;
        this.currentEnergy = other.currentEnergy;
        this.maxEnergy = other.maxEnergy;
        this.lastProduction = other.lastProduction;
        this.lastConsumption = other.lastConsumption;
        this.isInitialized = other.isInitialized;
    }

    public int getLastProduction() {
        return this.lastProduction;
    }

    public int getLastConsumption() {
        return this.lastConsumption;
    }

    public void fillWithHumanParts() {
        if (this.isInitialized) {
            return;
        }
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_BRAIN, new ItemStack((ItemLike)ModItems.HUMAN_BRAIN.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_HEART, new ItemStack((ItemLike)ModItems.HUMAN_HEART.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_STOMACH, new ItemStack((ItemLike)ModItems.HUMAN_STOMACH.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_SKIN, new ItemStack((ItemLike)ModItems.HUMAN_SKIN.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_MUSCLE, new ItemStack((ItemLike)ModItems.HUMAN_MUSCLE.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_BONES, new ItemStack((ItemLike)ModItems.HUMAN_BONE.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_EYES, new ItemStack((ItemLike)ModItems.HUMAN_EYES.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_LUNGS, new ItemStack((ItemLike)ModItems.HUMAN_LUNGS.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_ARMS, new ItemStack((ItemLike)ModItems.HUMAN_LEFT_ARM.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_ARMS + 1, new ItemStack((ItemLike)ModItems.HUMAN_RIGHT_ARM.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_HANDS + 1, new ItemStack((ItemLike)ModItems.HUMAN_LEFT_HAND.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_HANDS, new ItemStack((ItemLike)ModItems.HUMAN_RIGHT_HAND.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_LEGS, new ItemStack((ItemLike)ModItems.HUMAN_LEFT_LEG.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_LEGS + 1, new ItemStack((ItemLike)ModItems.HUMAN_RIGHT_LEG.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_BOOTS + 1, new ItemStack((ItemLike)ModItems.HUMAN_LEFT_FOOT.get()));
        this.installedCyberware.setStackInSlot(RobosurgeonBlockEntity.SLOT_BOOTS, new ItemStack((ItemLike)ModItems.HUMAN_RIGHT_FOOT.get()));
        this.isInitialized = true;
        this.updateLimbStatus();
    }

    public int getTolerance() {
        int consumed = 0;
        for (int i = 0; i < this.installedCyberware.getSlots(); ++i) {
            Item item;
            ItemStack stack = this.installedCyberware.getStackInSlot(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cyberware = (ICyberware)item;
            consumed += cyberware.getEssenceCost(stack) * stack.m_41613_();
        }
        return this.maxTolerance - consumed;
    }

    public ItemStackHandler getInstalledCyberware() {
        return this.installedCyberware;
    }

    public void syncToClient(ServerPlayer player) {
        if (player == null) {
            return;
        }
        CompoundTag tag = this.serializeNBT();
        A_PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncCyberwareDataPacket(tag));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("InstalledCyberware", (Tag)this.installedCyberware.serializeNBT());
        tag.m_128405_("MaxTolerance", this.maxTolerance);
        tag.m_128379_("IsInitialized", this.isInitialized);
        tag.m_128405_("ImmunityTime", this.toleranceImmunityTime);
        tag.m_128405_("MaxEnergy", this.maxEnergy);
        tag.m_128405_("LastProd", this.lastProduction);
        tag.m_128405_("LastCons", this.lastConsumption);
        tag.m_128405_("CurrentEnergy", this.currentEnergy);
        return tag;
    }

    public boolean isCyberwareInstalled(Item item) {
        for (int i = 0; i < this.installedCyberware.getSlots(); ++i) {
            ItemStack stack = this.installedCyberware.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("InstalledCyberware")) {
            this.installedCyberware.deserializeNBT(nbt.m_128469_("InstalledCyberware"));
        }
        if (nbt.m_128441_("MaxTolerance")) {
            this.maxTolerance = nbt.m_128451_("MaxTolerance");
        }
        if (nbt.m_128441_("IsInitialized")) {
            this.isInitialized = nbt.m_128471_("IsInitialized");
        }
        if (nbt.m_128441_("MaxEnergy")) {
            this.maxEnergy = nbt.m_128451_("MaxEnergy");
        }
        if (nbt.m_128441_("CurrentEnergy")) {
            this.currentEnergy = nbt.m_128451_("CurrentEnergy");
        }
        if (nbt.m_128441_("LastProd")) {
            this.lastProduction = nbt.m_128451_("LastProd");
        }
        if (nbt.m_128441_("LastCons")) {
            this.lastConsumption = nbt.m_128451_("LastCons");
        }
        if (nbt.m_128441_("ImmunityTime")) {
            this.toleranceImmunityTime = nbt.m_128451_("ImmunityTime");
        }
        this.updateLimbStatus();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.maxEnergy - this.currentEnergy, maxReceive);
        if (!simulate) {
            this.currentEnergy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.currentEnergy, maxExtract);
        if (!simulate) {
            this.currentEnergy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.currentEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return this.maxEnergy > 0;
    }

    public boolean canReceive() {
        return this.maxEnergy > 0;
    }
}

