/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Entity.Monster.CyberSkeleton;

import com.Maxwell.cyber_ware_port.Common.Entity.ICyberwareMob;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import java.util.Arrays;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CyberSkeletonEntity
extends Skeleton
implements ICyberwareMob {
    private static final int MELEE_TRIGGER_DIST_SQR = 25;
    private static final int MELEE_COOLDOWN_TICKS = 100;
    private static final int MAX_MELEE_ATTACKS = 5;
    public int meleeCooldown = 0;
    public int attackCounter = 0;

    public CyberSkeletonEntity(EntityType<? extends Skeleton> type, Level level) {
        super(type, level);
    }

    @Override
    public List<Item> getSpecialDrops() {
        return Arrays.asList((Item)ModItems.RAPID_FIRE_FLYWHEEL.get(), (Item)ModItems.LINEAR_ACTUATORS.get());
    }

    @Override
    public List<Item> getForbiddenDrops() {
        return Arrays.asList((Item)ModItems.CYBER_ARM_LEFT.get(), (Item)ModItems.CYBER_ARM_RIGHT.get(), (Item)ModItems.CYBER_LEG_LEFT.get(), (Item)ModItems.CYBER_LEG_RIGHT.get(), (Item)ModItems.INTERNAL_DEFIBRILLATOR.get());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new CyberMeleeGoal(this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new CyberBowAttackGoal(this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected boolean m_21527_() {
        return false;
    }

    public void m_32164_() {
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.meleeCooldown > 0) {
            --this.meleeCooldown;
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack arrowStack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.m_6686_(d0, d1 + d3 * 0.2, d2, 2.5f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    static class CyberMeleeGoal
    extends MeleeAttackGoal {
        private final CyberSkeletonEntity skeleton;

        public CyberMeleeGoal(CyberSkeletonEntity mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)mob, speedModifier, followingTargetEvenIfNotSeen);
            this.skeleton = mob;
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (this.skeleton.m_5448_() == null || this.skeleton.meleeCooldown > 0) {
                return false;
            }
            double distSqr = this.skeleton.m_20280_((Entity)this.skeleton.m_5448_());
            return distSqr <= 25.0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.skeleton.meleeCooldown = 100;
        }
    }

    static class CyberBowAttackGoal
    extends RangedBowAttackGoal<CyberSkeletonEntity> {
        private final CyberSkeletonEntity skeleton;

        public CyberBowAttackGoal(CyberSkeletonEntity mob, double speedModifier, int attackIntervalMin, float attackRadius) {
            super((Mob)mob, speedModifier, attackIntervalMin, attackRadius);
            this.skeleton = mob;
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (this.skeleton.m_5448_() == null || this.skeleton.meleeCooldown > 0) {
                return false;
            }
            double distSqr = this.skeleton.m_20280_((Entity)this.skeleton.m_5448_());
            return distSqr > 25.0;
        }
    }
}

