/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Network;

import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.RobosurgeonBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareUserData;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;

public class PacketSurgeryGhostToggle {
    private final BlockPos pos;
    private final int slotId;

    public PacketSurgeryGhostToggle(BlockPos pos, int slotId) {
        this.pos = pos;
        this.slotId = slotId;
    }

    public PacketSurgeryGhostToggle(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.slotId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.slotId);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BlockEntity be;
            Level level;
            ServerPlayer player = context.getSender();
            if (player != null && (level = player.m_9236_()).m_46749_(this.pos) && (be = level.m_7702_(this.pos)) instanceof RobosurgeonBlockEntity) {
                RobosurgeonBlockEntity tile = (RobosurgeonBlockEntity)be;
                this.handleToggle(tile, player, this.slotId);
            }
        });
        context.setPacketHandled(true);
    }

    private void handleToggle(RobosurgeonBlockEntity tile, ServerPlayer player, int slotId) {
        ItemStackHandler body;
        ItemStack installed;
        LazyOptional cap;
        ItemStack currentStack = tile.getItemHandler().getStackInSlot(slotId);
        boolean changed = false;
        if (!currentStack.m_41619_() && currentStack.m_41782_() && currentStack.m_41783_().m_128471_("cyberware_ghost")) {
            tile.getItemHandler().setStackInSlot(slotId, ItemStack.f_41583_);
            changed = true;
        } else if (currentStack.m_41619_() && (cap = player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY)).isPresent() && !(installed = (body = ((CyberwareUserData)cap.resolve().get()).getInstalledCyberware()).getStackInSlot(slotId)).m_41619_()) {
            ItemStack ghost = installed.m_41777_();
            ghost.m_41784_().m_128379_("cyberware_ghost", true);
            tile.getItemHandler().setStackInSlot(slotId, ghost);
            changed = true;
        }
        if (changed) {
            tile.m_6596_();
            player.m_9236_().m_7260_(tile.m_58899_(), tile.m_58900_(), tile.m_58900_(), 3);
        }
    }
}

