/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.koopascritters.entity;

import java.util.List;
import java.util.function.Predicate;
import net.mcreator.koopascritters.entity.GiantAfricanLandSnailEntity;
import net.mcreator.koopascritters.entity.MexicanRosyBoaEntity;
import net.mcreator.koopascritters.entity.ServalEntity;
import net.mcreator.koopascritters.entity.TreeLobsterEntity;
import net.mcreator.koopascritters.entity.TricolorHognoseSnakeEntity;
import net.mcreator.koopascritters.init.KoopascrittersModEntities;
import net.mcreator.koopascritters.init.KoopascrittersModItems;
import net.mcreator.koopascritters.procedures.DoPredatoryBehaviorProcedure;
import net.mcreator.koopascritters.procedures.GuineafowlBabySizeProcedure;
import net.mcreator.koopascritters.procedures.HelmetedGuineafowlEntityIsHurtProcedure;
import net.mcreator.koopascritters.procedures.HelmetedGuineafowlNaturalEntitySpawningConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HelmetedGuineafowlEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(HelmetedGuineafowlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(HelmetedGuineafowlEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(HelmetedGuineafowlEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public HelmetedGuineafowlEntity(EntityType<HelmetedGuineafowlEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"guineafowl");
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ServalEntity.class, true, true){

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, MexicanRosyBoaEntity.class, true, true){

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Ocelot.class, true, true){

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, GiantAfricanLandSnailEntity.class, true, true){

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, TreeLobsterEntity.class, true, true){

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, TricolorHognoseSnakeEntity.class, true, true){

            public boolean canUse() {
                double x = HelmetedGuineafowlEntity.this.getX();
                double y = HelmetedGuineafowlEntity.this.getY();
                double z = HelmetedGuineafowlEntity.this.getZ();
                HelmetedGuineafowlEntity entity = HelmetedGuineafowlEntity.this;
                Level world = HelmetedGuineafowlEntity.this.level();
                return super.canUse() && DoPredatoryBehaviorProcedure.execute();
            }
        });
        this.goalSelector.addGoal(11, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(13, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(14, (Goal)new FollowMobGoal((Mob)this, 1.0, 15.0f, 3.0f));
        this.goalSelector.addGoal(15, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(16, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(17, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT_SEEDS}), false));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)KoopascrittersModItems.RAW_WILD_BIRD.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"koopascritters:guineafowlambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"koopascritters:guineafowlhurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"koopascritters:guineafowldeath"));
    }

    public boolean hurt(DamageSource source, float amount) {
        HelmetedGuineafowlEntityIsHurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        Entity immediatesourceentity = source.getDirectEntity();
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
    }

    public void baseTick() {
        super.baseTick();
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        HelmetedGuineafowlEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return super.getDefaultDimensions(pose).scale((float)GuineafowlBabySizeProcedure.execute((Entity)entity));
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        HelmetedGuineafowlEntity retval = (HelmetedGuineafowlEntity)((EntityType)KoopascrittersModEntities.HELMETED_GUINEAFOWL.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return List.of(Items.WHEAT_SEEDS, Items.PUMPKIN_SEEDS, Items.TORCHFLOWER_SEEDS, Items.MELON_SEEDS, Items.BEETROOT_SEEDS).contains(stack.getItem());
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)KoopascrittersModEntities.HELMETED_GUINEAFOWL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return HelmetedGuineafowlNaturalEntitySpawningConditionProcedure.execute();
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 9.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if ((event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) && this.onGround()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isInWaterOrBubble()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (!this.onGround()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("fly"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 6L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 7, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 7, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 7, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

