/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.mixin;

import com.mafuyu404.instantlyinteractinternally.Instantlyinteractinternally;
import com.mafuyu404.instantlyinteractinternally.utils.VirtualContainerGuard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin {
    private static boolean isContainerSlot(Slot slot) {
        return slot != null && !(slot.f_40218_ instanceof Inventory);
    }

    private static Player getPlayerFromMenu(AbstractContainerMenu self) {
        for (Slot slot : self.f_38839_) {
            Container container;
            if (slot == null || !((container = slot.f_40218_) instanceof Inventory)) continue;
            Inventory inv = (Inventory)container;
            return inv.f_35978_;
        }
        return null;
    }

    @Inject(method={"clicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void i3_blockSelfAndNestedOnClicked(int slotId, int button, ClickType clickType, Player player, CallbackInfo ci) {
        String sid;
        boolean intendsPlace;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        AbstractContainerMenu self = (AbstractContainerMenu)this;
        if (slotId < 0 || slotId >= self.f_38839_.size()) {
            return;
        }
        Slot target = (Slot)self.f_38839_.get(slotId);
        if (!AbstractContainerMenuMixin.isContainerSlot(target)) {
            return;
        }
        ItemStack carried = self.m_142621_();
        if (carried == null || carried.m_41619_()) {
            return;
        }
        boolean bl = intendsPlace = clickType == ClickType.PICKUP || clickType == ClickType.QUICK_CRAFT || clickType == ClickType.SWAP;
        if (!intendsPlace) {
            return;
        }
        VirtualContainerGuard.Session s = VirtualContainerGuard.getSession(sp);
        if (s != null && !s.isContainerSession && s.containerMenu == self && carried.m_41782_() && (sid = carried.m_41783_().m_128461_("i3_session")) != null && !sid.isEmpty() && sid.equals(s.sessionId)) {
            Instantlyinteractinternally.LOGGER.warn("[Mixin] \u963b\u6b62\u81ea\u5305\u542b: \u5728 {} \u4e2d\u5c1d\u8bd5\u628a sid={} \u653e\u5165\u5176\u81ea\u8eabGUI\u69fd\u4f4d \u73a9\u5bb6={}", new Object[]{self.getClass().getSimpleName(), sid, sp.m_36316_().getName()});
            ci.cancel();
        }
    }

    @Inject(method={"moveItemStackTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void i3_blockSelfAndNestedOnMove(ItemStack stack, int startIndex, int endIndex, boolean reverse, CallbackInfoReturnable<Boolean> cir) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        AbstractContainerMenu self = (AbstractContainerMenu)this;
        boolean targetIncludesContainerSlot = false;
        int from = Math.min(startIndex, endIndex);
        int to = Math.max(startIndex, endIndex);
        if (from < 0) {
            from = 0;
        }
        if (to > self.f_38839_.size()) {
            to = self.f_38839_.size();
        }
        for (int i = from; i < to; ++i) {
            if (!AbstractContainerMenuMixin.isContainerSlot((Slot)self.f_38839_.get(i))) continue;
            targetIncludesContainerSlot = true;
            break;
        }
        if (!targetIncludesContainerSlot) {
            return;
        }
        Player p = AbstractContainerMenuMixin.getPlayerFromMenu(self);
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)p;
        if (stack.m_41782_()) {
            String sid = stack.m_41783_().m_128461_("i3_session");
            VirtualContainerGuard.Session sActive = VirtualContainerGuard.getSession(sp);
            if (sActive != null && !sActive.isContainerSession && self == sActive.containerMenu && sid != null && !sid.isEmpty() && sid.equals(sActive.sessionId)) {
                Instantlyinteractinternally.LOGGER.warn("[Mixin] \u963b\u6b62\u81ea\u5305\u542b(\u5feb\u901f\u79fb\u52a8): \u5728 {} \u4e2d\u5c1d\u8bd5\u628a sid={} \u5feb\u901f\u79fb\u5165\u5176\u81ea\u8eabGUI", (Object)self.getClass().getSimpleName(), (Object)sid);
                cir.setReturnValue((Object)false);
            }
        }
    }
}

