/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils;

import com.mafuyu404.instantlyinteractinternally.utils.Config;
import com.mafuyu404.instantlyinteractinternally.utils.FakeLevel;
import com.mafuyu404.instantlyinteractinternally.utils.VirtualContainerGuard;
import com.mafuyu404.instantlyinteractinternally.utils.service.ContainerHelper;
import com.mafuyu404.instantlyinteractinternally.utils.service.SessionService;
import com.mafuyu404.instantlyinteractinternally.utils.service.UseProgressTracker;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContextRegistry;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static void interactBlockInSandbox(ItemStack stack, ServerPlayer player) {
        BlockEntity be;
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockItem.m_40614_());
        if (!Config.isBlockAllowed(blockId)) {
            player.m_5661_((Component)Component.m_237115_((String)"iii.block_open_denied").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (stack.m_41613_() > 1) {
            player.m_5661_((Component)Component.m_237115_((String)"iii.open_multiple_block_denied").m_130940_(ChatFormatting.RED), true);
            return;
        }
        FakeLevel fake = WorldContextRegistry.getOrCreateLevel(player);
        boolean nestedOpen = false;
        VirtualContainerGuard.Session active = VirtualContainerGuard.getSession(player);
        AbstractContainerMenu currentMenu = player.f_36096_;
        if (currentMenu != null && !(currentMenu instanceof InventoryMenu)) {
            nestedOpen = true;
        }
        if (!nestedOpen) {
            SessionService.flushActiveSession(player);
        }
        String sessionId = UUID.randomUUID().toString();
        BlockPos pos = SessionService.ensurePosForSession(player, sessionId);
        BlockState target = blockItem.m_40614_().m_49966_();
        if (fake.m_8055_(pos).m_60734_() != target.m_60734_()) {
            fake.putBlock(pos, target);
        }
        if ((be = fake.m_7702_(pos)) != null && ContainerHelper.isContainerEmpty(be) && ContainerHelper.isContainerLike(be)) {
            Utils.applyBlockEntityTagToBE(stack, be, pos);
        }
        ClipContext clipContext = new ClipContext(player.m_20182_(), pos.m_252807_(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null);
        BlockHitResult traceResult = fake.m_45547_(clipContext);
        MenuProvider provider = target.m_60750_((Level)fake, pos);
        if (provider == null) {
            InteractionResult result = target.m_60664_((Level)fake, (Player)player, InteractionHand.MAIN_HAND, traceResult);
            return;
        }
        stack.m_41784_().m_128359_("i3_session", sessionId);
        VirtualContainerGuard.setSuppressCloseSession(player, sessionId);
        SessionService.beginSession(player, sessionId, pos);
        player.m_5893_(provider);
    }

    public static void consumeItemInstant(Slot slot, ServerPlayer player) {
        boolean added;
        ItemStack inSlot = slot.m_7993_();
        if (inSlot.m_41619_()) {
            return;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)inSlot.m_41720_());
        if (!Config.isItemAllowed(itemId)) {
            player.m_5661_((Component)Component.m_237115_((String)"iii.item_use_denied").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (inSlot.m_41614_()) {
            boolean always;
            FoodProperties food = inSlot.getFoodProperties((LivingEntity)player);
            boolean bl = always = food != null && food.m_38747_();
            if (!player.m_36391_(always)) {
                return;
            }
            if (((Boolean)Config.ENABLE_USE_PROGRESS.get()).booleanValue()) {
                UseProgressTracker.beginUseFromSlot(player, slot);
                return;
            }
        } else if (inSlot.m_41720_() instanceof PotionItem) {
            if (((Boolean)Config.ENABLE_USE_PROGRESS.get()).booleanValue()) {
                UseProgressTracker.beginUseFromSlot(player, slot);
                return;
            }
        } else {
            return;
        }
        Level level = player.m_9236_();
        ItemStack one = inSlot.m_41777_();
        one.m_41764_(1);
        ItemStack containerResult = one.m_41671_(level, (LivingEntity)player);
        inSlot.m_41774_(1);
        if (inSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_5852_(inSlot);
        }
        slot.m_6654_();
        if (!containerResult.m_41619_() && !(added = player.m_150109_().m_36054_(containerResult))) {
            player.m_36176_(containerResult, false);
        }
        player.f_36096_.m_38946_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useUsableItemInstant(Slot slot, ServerPlayer player) {
        boolean added;
        if (player.m_9236_().f_46443_) {
            return false;
        }
        ItemStack inSlot = slot.m_7993_();
        if (inSlot.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)inSlot.m_41720_());
        if (!Config.isItemAllowed(itemId)) {
            player.m_5661_((Component)Component.m_237115_((String)"iii.item_use_denied").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        Item item = inSlot.m_41720_();
        if (inSlot.m_41614_() || item instanceof PotionItem && !(item instanceof ThrowablePotionItem)) {
            return false;
        }
        ServerLevel level = player.m_284548_();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack one = inSlot.m_41777_();
        one.m_41764_(1);
        ItemStack handBackup = player.m_21120_(hand).m_41777_();
        player.m_21008_(hand, one);
        boolean consumed = false;
        ItemStack afterHand = ItemStack.f_41583_;
        try {
            InteractionResultHolder useResult = one.m_41682_((Level)level, (Player)player, hand);
            if (useResult != null && useResult.m_19089_().m_19077_()) {
                consumed = true;
                afterHand = player.m_21120_(hand).m_41777_();
            } else {
                BlockHitResult hit = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (hit.m_6662_() == HitResult.Type.BLOCK) {
                    InteractionResult useOnResult = player.m_21120_(hand).onItemUseFirst(new UseOnContext((Player)player, hand, hit));
                    if (useOnResult != InteractionResult.PASS && useOnResult.m_19077_()) {
                        consumed = true;
                        afterHand = player.m_21120_(hand).m_41777_();
                    } else {
                        InteractionResult finalResult = player.m_21120_(hand).m_41661_(new UseOnContext((Player)player, hand, hit));
                        if (finalResult.m_19077_()) {
                            consumed = true;
                            afterHand = player.m_21120_(hand).m_41777_();
                        }
                    }
                }
            }
        }
        finally {
            player.m_21008_(hand, handBackup);
        }
        if (!consumed) {
            return false;
        }
        inSlot.m_41774_(1);
        if (inSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_5852_(inSlot);
        }
        slot.m_6654_();
        if (afterHand != null && !afterHand.m_41619_() && !(added = player.m_150109_().m_36054_(afterHand))) {
            player.m_36176_(afterHand, false);
        }
        player.m_21011_(hand, true);
        player.f_36096_.m_38946_();
        return true;
    }

    public static void clearPendingBind(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_("i3_pending_bind");
        tag.m_128473_("i3_pending_key");
        if (tag.m_128456_()) {
            stack.m_41751_(null);
        }
    }

    public static void writeBlockEntityTagToItem(BlockEntity be, ItemStack stack) {
        CompoundTag full = be.m_187480_();
        if (full == null) {
            return;
        }
        full.m_128473_("x");
        full.m_128473_("y");
        full.m_128473_("z");
        stack.m_41784_().m_128365_("BlockEntityTag", (Tag)full);
    }

    public static void applyBlockEntityTagToBE(ItemStack stack, BlockEntity be, BlockPos pos) {
        CompoundTag beTag = BlockItem.m_186336_((ItemStack)stack);
        if (beTag == null) {
            return;
        }
        CompoundTag copy = beTag.m_6426_();
        copy.m_128405_("x", pos.m_123341_());
        copy.m_128405_("y", pos.m_123342_());
        copy.m_128405_("z", pos.m_123343_());
        be.m_142466_(copy);
        be.m_6596_();
        Utils.clearBlockEntityTag(stack);
    }

    public static void clearBlockEntityTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_("BlockEntityTag");
        if (tag.m_128456_()) {
            stack.m_41751_(null);
        }
    }
}

