/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils;

import com.mafuyu404.instantlyinteractinternally.Instantlyinteractinternally;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class VirtualContainerGuard {
    private static final Set<UUID> ACTIVE = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Deque<Session>> SESSIONS = new ConcurrentHashMap<UUID, Deque<Session>>();
    private static final Map<UUID, Set<String>> SUPPRESS_CLOSE = new ConcurrentHashMap<UUID, Set<String>>();

    private VirtualContainerGuard() {
    }

    public static void begin(ServerPlayer player) {
        ACTIVE.add(player.m_20148_());
    }

    public static void end(ServerPlayer player) {
        ACTIVE.remove(player.m_20148_());
        SESSIONS.remove(player.m_20148_());
    }

    public static boolean isActive(ServerPlayer player) {
        return ACTIVE.contains(player.m_20148_());
    }

    public static void beginSession(ServerPlayer player, String sessionId, BlockPos pos) {
        ACTIVE.add(player.m_20148_());
        Deque dq = SESSIONS.computeIfAbsent(player.m_20148_(), k -> new ArrayDeque());
        AbstractContainerMenu parent = player.f_36096_;
        Session top = (Session)dq.peekFirst();
        if (!(parent == null || top != null && top.containerMenu == parent && top.isContainerSession)) {
            Session parentSess = new Session("__container__:" + sessionId, pos);
            parentSess.parentContainer = null;
            parentSess.containerMenu = parent;
            parentSess.isContainerSession = true;
            dq.push(parentSess);
            Instantlyinteractinternally.debug("[VCG] \u63a8\u5165\u7236\u5bb9\u5668\u4f1a\u8bdd\u5360\u4f4d\u7b26 menu={} \u73a9\u5bb6={}", parent.getClass().getSimpleName(), player.m_36316_().getName());
        }
        Session s = new Session(sessionId, pos);
        s.parentContainer = parent;
        s.isContainerSession = false;
        dq.push(s);
        Instantlyinteractinternally.debug("[VCG] \u5f00\u59cb\u5b50\u4f1a\u8bdd id={} pos={} parentMenu={} \u73a9\u5bb6={}", sessionId, pos, parent != null ? parent.getClass().getSimpleName() : "null", player.m_36316_().getName());
    }

    public static void endSession(ServerPlayer player) {
        ACTIVE.remove(player.m_20148_());
        SESSIONS.remove(player.m_20148_());
        SUPPRESS_CLOSE.remove(player.m_20148_());
    }

    public static void endCurrentSession(ServerPlayer player) {
        Deque<Session> dq = SESSIONS.get(player.m_20148_());
        if (dq == null) {
            return;
        }
        Session popped = dq.pollFirst();
        if (popped != null) {
            Instantlyinteractinternally.debug("[VCG] \u5f39\u51fa\u4f1a\u8bdd id={} isContainerSession={} \u73a9\u5bb6={}", popped.sessionId, popped.isContainerSession, player.m_36316_().getName());
        }
        if (dq.isEmpty()) {
            SESSIONS.remove(player.m_20148_());
        }
    }

    public static Session getSession(ServerPlayer player) {
        Deque<Session> dq = SESSIONS.get(player.m_20148_());
        return dq != null ? dq.peekFirst() : null;
    }

    public static void setCurrentContainer(ServerPlayer player, AbstractContainerMenu menu) {
        Session s;
        Deque<Session> dq = SESSIONS.get(player.m_20148_());
        if (dq != null && (s = dq.peekFirst()) != null) {
            s.containerMenu = menu;
        }
    }

    public static void setSuppressCloseSession(ServerPlayer player, String sessionId) {
        Set set = SUPPRESS_CLOSE.computeIfAbsent(player.m_20148_(), k -> ConcurrentHashMap.newKeySet());
        set.add(sessionId);
    }

    public static Set<String> getSuppressedCloseSessionIds(ServerPlayer player) {
        Set<String> set = SUPPRESS_CLOSE.get(player.m_20148_());
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public static void clearSuppressedCloseSession(ServerPlayer player, String sessionId) {
        Set<String> set = SUPPRESS_CLOSE.get(player.m_20148_());
        if (set != null) {
            set.remove(sessionId);
            if (set.isEmpty()) {
                SUPPRESS_CLOSE.remove(player.m_20148_());
            }
        }
    }

    public static boolean endSessionById(ServerPlayer player, String sessionId) {
        Deque<Session> dq = SESSIONS.get(player.m_20148_());
        if (dq == null || sessionId == null) {
            return false;
        }
        Iterator<Session> it = dq.iterator();
        while (it.hasNext()) {
            Session s = it.next();
            if (s.isContainerSession || !sessionId.equals(s.sessionId)) continue;
            it.remove();
            Instantlyinteractinternally.debug("[VCG] \u6309ID\u7ed3\u675f\u4f1a\u8bdd id={} \u73a9\u5bb6={}", sessionId, player.m_36316_().getName());
            if (dq.isEmpty()) {
                SESSIONS.remove(player.m_20148_());
            }
            return true;
        }
        return false;
    }

    public static Session getTopItemSession(ServerPlayer player) {
        Deque<Session> dq = SESSIONS.get(player.m_20148_());
        if (dq == null) {
            return null;
        }
        for (Session s : dq) {
            if (s.isContainerSession) continue;
            return s;
        }
        return null;
    }

    public static final class Session {
        public final String sessionId;
        public final BlockPos pos;
        public AbstractContainerMenu containerMenu;
        public AbstractContainerMenu parentContainer;
        public boolean isContainerSession;

        public Session(String sessionId, BlockPos pos) {
            this.sessionId = sessionId;
            this.pos = pos;
        }
    }
}

