/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils.service;

import com.mafuyu404.instantlyinteractinternally.Instantlyinteractinternally;
import com.mafuyu404.instantlyinteractinternally.api.FakeLevelAPI;
import com.mafuyu404.instantlyinteractinternally.utils.Utils;
import com.mafuyu404.instantlyinteractinternally.utils.VirtualContainerGuard;
import com.mafuyu404.instantlyinteractinternally.utils.service.ContainerHelper;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContext;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContextRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class SessionService {
    private SessionService() {
    }

    public static void beginSession(ServerPlayer player, String sessionId, BlockPos pos) {
        VirtualContainerGuard.beginSession(player, sessionId, pos);
        Instantlyinteractinternally.debug("[SS] \u5f00\u59cb\u4f1a\u8bdd id={} pos={} \u73a9\u5bb6={}", sessionId, pos, player.m_36316_().getName());
    }

    public static void endSession(ServerPlayer player) {
        VirtualContainerGuard.endSession(player);
    }

    public static ResourceLocation groupForPlayer(ServerPlayer sp, String suffix) {
        return new ResourceLocation("i3", "player/" + sp.m_20149_() + "/" + suffix);
    }

    public static ResourceLocation groupForSession(ServerPlayer sp, String sessionId) {
        return new ResourceLocation("i3", "session/" + sp.m_20149_() + "/" + sessionId);
    }

    public static void scheduleForPlayer(ServerPlayer sp, Runnable task, String suffix, int delayTicks, int throttlePerTick, boolean coalesce) {
        FakeLevelAPI.scheduleTaskEx(sp, task, SessionService.groupForPlayer(sp, suffix), delayTicks, throttlePerTick, coalesce);
    }

    public static void scheduleForSession(ServerPlayer sp, String sessionId, Runnable task, int delayTicks, int throttlePerTick, boolean coalesce) {
        FakeLevelAPI.scheduleTaskEx(sp, task, SessionService.groupForSession(sp, sessionId), delayTicks, throttlePerTick, coalesce);
    }

    public static String getActiveSessionId(ServerPlayer sp) {
        VirtualContainerGuard.Session session = VirtualContainerGuard.getTopItemSession(sp);
        return session != null ? session.sessionId : null;
    }

    public static BlockPos ensurePosForSession(ServerPlayer player, String sessionId) {
        return WorldContextRegistry.ensurePosForSession(player, sessionId);
    }

    public static void flushActiveSession(ServerPlayer sp) {
        SessionService.flushActiveSession(sp, true);
    }

    public static void flushActiveSession(ServerPlayer sp, boolean finalize) {
        VirtualContainerGuard.Session sess = VirtualContainerGuard.getTopItemSession(sp);
        if (sess == null) {
            return;
        }
        WorldContextRegistry.maybeLoadContext(sp);
        WorldContext ctx = WorldContextRegistry.getContext(sp);
        if (ctx == null) {
            VirtualContainerGuard.endCurrentSession(sp);
            return;
        }
        String sessionId = sess.sessionId;
        BlockPos pos = ctx.sessionToPos.get(sessionId);
        BlockEntity be = null;
        if (pos != null) {
            be = ctx.level.m_7702_(pos);
        }
        AbstractContainerMenu preferMenu = sess.parentContainer;
        WriteBackResult slotResult = SessionService.tryWriteViaPreferSlot(be, preferMenu, sessionId);
        boolean wrote = slotResult.wrote;
        ItemStack usedStack = slotResult.stack;
        if (!wrote) {
            WriteBackResult stackResult = SessionService.tryWriteViaLocatedStack(sp, be, preferMenu, sessionId);
            wrote = stackResult.wrote;
            usedStack = stackResult.stack;
        }
        if (!wrote) {
            WriteBackResult beResult = SessionService.tryWriteViaBEInventory(be, sessionId);
            wrote = beResult.wrote;
            usedStack = beResult.stack;
        }
        if (!wrote && be != null && !ContainerHelper.isContainerLike(be)) {
            Instantlyinteractinternally.debug("[SS] \u76ee\u6807\u65b9\u5757\u4e0d\u542b\u5e93\u5b58\uff0csid={} \u4ec5\u505a\u4f1a\u8bdd\u6e05\u7406", sessionId);
        }
        if (finalize) {
            if (!usedStack.m_41619_()) {
                SessionService.removeSessionTag(usedStack);
            } else {
                ItemStack fallback = SessionService.findStackBySession(sp, sessionId, preferMenu);
                if (!fallback.m_41619_()) {
                    SessionService.removeSessionTag(fallback);
                }
            }
            ctx.sessionToPos.remove(sessionId);
            Instantlyinteractinternally.debug("[SS] \u5b8c\u6210\u6700\u7ec8\u5237\u76d8\uff1a\u79fb\u9664 sid={} \u7684\u6620\u5c04\u4e0e\u6807\u7b7e", sessionId);
            VirtualContainerGuard.endCurrentSession(sp);
            VirtualContainerGuard.Session top = VirtualContainerGuard.getSession(sp);
            if (top != null && top.isContainerSession && sp.f_36096_ != top.containerMenu) {
                Instantlyinteractinternally.debug("[SS] finalize \u540e\u6e05\u7406\u5931\u6548\u7236\u5bb9\u5668\u5360\u4f4d menu={}", top.containerMenu != null ? top.containerMenu.getClass().getSimpleName() : "null");
                VirtualContainerGuard.endCurrentSession(sp);
            }
        }
        SessionService.scheduleForPlayer(sp, () -> sp.f_36096_.m_38946_(), "ui/refresh", 0, 1, true);
    }

    private static WriteBackResult tryWriteViaPreferSlot(BlockEntity be, AbstractContainerMenu preferMenu, String sessionId) {
        WriteBackResult res = new WriteBackResult();
        if (be == null || !ContainerHelper.isContainerLike(be)) {
            return res;
        }
        Slot preferSlot = SessionService.findSlotWithSessionInContainer(preferMenu, sessionId);
        if (preferSlot == null) {
            return res;
        }
        ItemStack s = preferSlot.m_7993_();
        boolean empty = ContainerHelper.isContainerEmpty(be);
        if (!empty) {
            Utils.writeBlockEntityTagToItem(be, s);
            Instantlyinteractinternally.debug("[SS] [Slot] \u5199\u5165 BlockEntityTag sid={} empty=false", sessionId);
        } else {
            Utils.clearBlockEntityTag(s);
            Instantlyinteractinternally.debug("[SS] [Slot] \u6e05\u9664 BlockEntityTag sid={} empty=true", sessionId);
        }
        preferSlot.m_6654_();
        if (preferSlot.f_40218_ != null) {
            preferSlot.f_40218_.m_6596_();
        }
        res.wrote = true;
        res.stack = s;
        return res;
    }

    private static WriteBackResult tryWriteViaLocatedStack(ServerPlayer sp, BlockEntity be, AbstractContainerMenu preferMenu, String sessionId) {
        WriteBackResult res = new WriteBackResult();
        if (be == null || !ContainerHelper.isContainerLike(be)) {
            return res;
        }
        ItemStack stack = SessionService.findStackBySession(sp, sessionId, preferMenu);
        Instantlyinteractinternally.debug("[SS] [Stack] sid={} preferMenu={} foundStack={}", sessionId, preferMenu != null ? preferMenu.getClass().getSimpleName() : "null", !stack.m_41619_());
        if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) {
            return res;
        }
        boolean empty = ContainerHelper.isContainerEmpty(be);
        if (!empty) {
            Utils.writeBlockEntityTagToItem(be, stack);
            Instantlyinteractinternally.debug("[SS] [Stack] \u5199\u5165 BlockEntityTag sid={} empty=false", sessionId);
        } else {
            Utils.clearBlockEntityTag(stack);
            Instantlyinteractinternally.debug("[SS] [Stack] \u6e05\u9664 BlockEntityTag sid={} empty=true", sessionId);
        }
        boolean dirtyDone = false;
        if (preferMenu != null) {
            for (Slot sl : preferMenu.f_38839_) {
                if (sl.m_7993_() != stack) continue;
                sl.m_6654_();
                if (sl.f_40218_ != null) {
                    sl.f_40218_.m_6596_();
                }
                dirtyDone = true;
                break;
            }
        }
        if (!dirtyDone) {
            sp.m_150109_().m_6596_();
        }
        res.wrote = true;
        res.stack = stack;
        return res;
    }

    private static WriteBackResult tryWriteViaBEInventory(BlockEntity be, String sessionId) {
        WriteBackResult res = new WriteBackResult();
        if (!(be instanceof Container)) {
            return res;
        }
        Container container = (Container)be;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack s = container.m_8020_(i);
            if (s.m_41619_() || !s.m_41782_() || !sessionId.equals(s.m_41783_().m_128461_("i3_session"))) continue;
            boolean empty = ContainerHelper.isContainerEmpty(be);
            if (!empty) {
                Utils.writeBlockEntityTagToItem(be, s);
                Instantlyinteractinternally.debug("[SS] [BE\u5e93\u5b58] \u5199\u5165 BlockEntityTag sid={} slot={} empty=false", sessionId, i);
            } else {
                Utils.clearBlockEntityTag(s);
                Instantlyinteractinternally.debug("[SS] [BE\u5e93\u5b58] \u6e05\u9664 BlockEntityTag sid={} slot={} empty=true", sessionId, i);
            }
            container.m_6596_();
            be.m_6596_();
            res.wrote = true;
            res.stack = s;
            break;
        }
        return res;
    }

    private static void removeSessionTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_("i3_session");
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public static void flushSessionsInContainer(ServerPlayer sp, AbstractContainerMenu container) {
        if (container == null) {
            return;
        }
        WorldContextRegistry.maybeLoadContext(sp);
        WorldContext ctx = WorldContextRegistry.getContext(sp);
        if (ctx == null) {
            return;
        }
        Set<String> suppressed = VirtualContainerGuard.getSuppressedCloseSessionIds(sp);
        HashSet<String> handled = new HashSet<String>();
        for (Slot slot : container.f_38839_) {
            CompoundTag tag;
            BlockEntity be;
            String sid;
            ItemStack s;
            if (slot.f_40218_ instanceof Inventory || (s = slot.m_7993_()).m_41619_() || !s.m_41782_() || (sid = s.m_41783_().m_128461_("i3_session")) == null || sid.isEmpty() || !handled.add(sid)) continue;
            if (suppressed.contains(sid)) {
                BlockEntity be2;
                Instantlyinteractinternally.debug("[SS] \u5173\u95ed\u5237\u76d8\uff08\u90e8\u5206\u5199\u56de\uff0c\u4fdd\u7559\u4f1a\u8bdd\uff09 sid={} slot={}", sid, slot.f_40219_);
                BlockPos pos = ctx.sessionToPos.get(sid);
                if (pos == null || (be2 = ctx.level.m_7702_(pos)) == null || !ContainerHelper.isContainerLike(be2)) continue;
                boolean empty = ContainerHelper.isContainerEmpty(be2);
                if (!empty) {
                    Utils.writeBlockEntityTagToItem(be2, s);
                } else {
                    Utils.clearBlockEntityTag(s);
                }
                slot.m_6654_();
                if (slot.f_40218_ == null) continue;
                slot.f_40218_.m_6596_();
                continue;
            }
            boolean wroteBack = false;
            BlockPos pos = ctx.sessionToPos.get(sid);
            if (pos != null && (be = ctx.level.m_7702_(pos)) != null && ContainerHelper.isContainerLike(be)) {
                boolean empty = ContainerHelper.isContainerEmpty(be);
                if (!empty) {
                    Utils.writeBlockEntityTagToItem(be, s);
                } else {
                    Utils.clearBlockEntityTag(s);
                }
                wroteBack = true;
                Instantlyinteractinternally.debug("[SS] \u5173\u95ed\u5bb9\u5668\u5199\u56de sid={} slot={}", sid, slot.f_40219_);
            }
            if (wroteBack) {
                ctx.sessionToPos.remove(sid);
                VirtualContainerGuard.endSessionById(sp, sid);
            }
            if ((tag = s.m_41783_()) != null) {
                tag.m_128473_("i3_session");
                if (tag.m_128456_()) {
                    s.m_41751_(null);
                }
            }
            slot.m_6654_();
            if (slot.f_40218_ == null) continue;
            slot.f_40218_.m_6596_();
        }
    }

    private static ItemStack findStackBySession(ServerPlayer sp, String sessionId, AbstractContainerMenu menu) {
        AbstractContainerMenu target;
        ItemStack carried;
        ItemStack s;
        int i;
        Inventory inv = sp.m_150109_();
        for (i = 0; i < inv.f_35974_.size(); ++i) {
            s = (ItemStack)inv.f_35974_.get(i);
            if (s.m_41619_() || !s.m_41782_() || !sessionId.equals(s.m_41783_().m_128461_("i3_session"))) continue;
            return s;
        }
        for (i = 0; i < inv.f_35976_.size(); ++i) {
            s = (ItemStack)inv.f_35976_.get(i);
            if (s.m_41619_() || !s.m_41782_() || !sessionId.equals(s.m_41783_().m_128461_("i3_session"))) continue;
            return s;
        }
        if (sp.f_36096_ != null && !(carried = sp.f_36096_.m_142621_()).m_41619_() && carried.m_41782_() && sessionId.equals(carried.m_41783_().m_128461_("i3_session"))) {
            return carried;
        }
        AbstractContainerMenu abstractContainerMenu = target = menu != null ? menu : sp.f_36096_;
        if (target != null) {
            for (Slot slot : target.f_38839_) {
                ItemStack s2 = slot.m_7993_();
                if (s2.m_41619_() || !s2.m_41782_() || !sessionId.equals(s2.m_41783_().m_128461_("i3_session"))) continue;
                return s2;
            }
        }
        return ItemStack.f_41583_;
    }

    private static Slot findSlotWithSessionInContainer(AbstractContainerMenu menu, String sessionId) {
        if (menu == null) {
            return null;
        }
        for (Slot slot : menu.f_38839_) {
            String sid;
            ItemStack s;
            if (slot.f_40218_ instanceof Inventory || (s = slot.m_7993_()).m_41619_() || !s.m_41782_() || !sessionId.equals(sid = s.m_41783_().m_128461_("i3_session"))) continue;
            return slot;
        }
        return null;
    }

    public static void finalizeSessionsForParentClose(ServerPlayer sp, AbstractContainerMenu parent) {
        VirtualContainerGuard.Session top;
        if (parent == null) {
            return;
        }
        Set<String> suppressed = VirtualContainerGuard.getSuppressedCloseSessionIds(sp);
        while ((top = VirtualContainerGuard.getSession(sp)) != null && !top.isContainerSession && top.parentContainer == parent) {
            if (suppressed.contains(top.sessionId)) {
                Instantlyinteractinternally.LOGGER.info("[SS] \u7236\u5bb9\u5668\u5173\u95ed\u65f6\u8df3\u8fc7\u88ab\u6291\u5236\u7684\u5b50\u4f1a\u8bdd sid={} parent={}", (Object)top.sessionId, (Object)parent.getClass().getSimpleName());
                break;
            }
            SessionService.flushActiveSession(sp, true);
        }
    }

    private static class WriteBackResult {
        boolean wrote = false;
        ItemStack stack = ItemStack.f_41583_;

        private WriteBackResult() {
        }
    }
}

