/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils.service;

import com.mafuyu404.instantlyinteractinternally.api.FakeLevelAPI;
import com.mafuyu404.instantlyinteractinternally.api.KeyPosProvider;
import com.mafuyu404.instantlyinteractinternally.utils.FakeLevel;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContext;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContextRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class TickService {
    private TickService() {
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerPlayer sp : TickService.spIterable()) {
            WorldContext ctx = WorldContextRegistry.getContext(sp);
            if (ctx == null) continue;
            KeyPosProvider provider = FakeLevelAPI.getKeyPosProvider(sp);
            FakeLevel level = ctx.level;
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            if (provider != null) {
                for (BlockPos blockPos : provider.allPositions(sp)) {
                    positions.add(blockPos);
                }
            }
            for (Map.Entry entry : ctx.sessionToPos.entrySet()) {
                positions.add((BlockPos)entry.getValue());
            }
            positions.addAll(level.allBlockEntityPositions());
            TickService.tickBlockEntitiesPositions(level, positions);
            FakeLevelAPI.drainTasks(sp, 0);
            sp.f_36096_.m_38946_();
        }
    }

    private static void tickBlockEntitiesPositions(FakeLevel level, Iterable<BlockPos> positions) {
        for (BlockPos pos : positions) {
            TickService.tickBlockEntityAt(level, pos);
        }
    }

    private static void tickBlockEntities(FakeLevel level, Iterable<? extends Map.Entry<?, BlockPos>> entries) {
        for (Map.Entry<?, BlockPos> entry : entries) {
            TickService.tickBlockEntityAt(level, entry.getValue());
        }
    }

    private static void tickBlockEntityAt(FakeLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        if (be != null) {
            BlockEntityTicker ticker;
            if (be.m_58904_() != level) {
                be.m_142339_((Level)level);
            }
            if ((ticker = state.m_155944_((Level)level, be.m_58903_())) != null) {
                ticker.m_155252_((Level)level, pos, state, be);
            }
        }
    }

    private static Iterable<ServerPlayer> spIterable() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null ? server.m_6846_().m_11314_() : Collections.emptyList();
    }
}

